/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.js":{"Yes_Change":"\u0646\u0639\u0645\u060c \u0642\u0628\u0648\u0644","add_on":"\u0625\u0636\u0627\u0641\u0629 \u0639\u0644\u0649","address_field":"\u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628.","admin":"\u0627\u0644\u0645\u0634\u0631\u0641","affiliation_amount_error":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062c\u0627\u0648\u0632 \u0645\u0628\u0644\u063a \u0627\u0644\u0627\u0646\u062a\u0645\u0627\u0621 100\u066a","agree_term":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0648\u0627\u0641\u0642 \u0639\u0644\u0649 \u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645.","allowed_file_types":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","allowed_image":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","amount":"\u0627\u0644\u0645\u0628\u0644\u063a","app_name_required":"\u062d\u0642\u0644 \u0627\u0633\u0645 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u0645\u0637\u0644\u0648\u0628","apply":"\u062a\u0642\u062f\u064a\u0645 \u0637\u0644\u0628","appointment":"\u0627\u0644\u0645\u0648\u0639\u062f","appointments":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f","approved":"\u0645\u0648\u0627\u0641\u0642 \u0639\u0644\u064a\u0647","apr":"\u0625\u0628\u0631\u064a\u0644","are_you_completed":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0647\u0630\u0627\u061f","are_you_sure":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","are_you_sure_dublicate_vcard":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0646\u0634\u0627\u0621 \u0646\u0633\u062e\u0629 \u0645\u0643\u0631\u0631\u0629 \u0645\u0646 \u0647\u0630\u0647 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0634\u062e\u0635\u064a\u0629\u061f","are_you_sure_want_to_delete_selected_Vcards":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \"Vcards\" \u0627\u0644\u0645\u062d\u062f\u062f\u0629\u061f","aug":"\u0623\u063a\u0633\u0637\u0633","back_image_field_required":"\u062d\u0642\u0644 \u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u062e\u0644\u0641\u064a\u0629 \u0645\u0637\u0644\u0648\u0628","blog":"\u0645\u062f\u0648\u0646\u0629","blog_description":"\u0648\u0635\u0641","blog_image_required":"\u062d\u0642\u0644 \u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u062f\u0648\u0646\u0629 \u0645\u0637\u0644\u0648\u0628.","cancel":"\u0625\u0644\u063a\u0627\u0621","check_email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0648\u062c\u0648\u062f \u0628\u0627\u0644\u0641\u0639\u0644.","choose_one_template":"\u0627\u062e\u062a\u0631 \u0623\u064a \u0642\u0627\u0644\u0628 \u0648\u0627\u062d\u062f","choose_plan":"\u0627\u062e\u062a\u0631 \u0627\u0644\u062e\u0637\u0629","city":"\u0627\u0644\u0645\u062f\u064a\u0646\u0629","click_open_sidebar":"\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \u0627\u0644\u062a\u0627\u0644\u064a \u0644\u0641\u062a\u062d \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a.","click_to_add_vcard_name":"\u0627\u0646\u0642\u0631 \u0647\u0646\u0627 \u0644\u0625\u0636\u0627\u0641\u0629 \u0627\u0633\u0645 Vcard \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","click_to_create_vcards":"\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \u0627\u0644\u062a\u0627\u0644\u064a \u0644\u0625\u0646\u0634\u0627\u0621 VCard \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","click_to_generate_alias":"\u0627\u0646\u0642\u0631 \u0647\u0646\u0627 \u0644\u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u062a\u0639\u0627\u0631 \u0644\u0639\u0646\u0648\u0627\u0646 URL \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","click_to_go_dashboard":"\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \"\u0627\u0644\u062a\u0627\u0644\u064a\" \u0644\u0644\u0645\u062a\u0627\u0628\u0639\u0629 \u0625\u0644\u0649 \u0644\u0648\u062d\u0629 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a.","click_to_make_vcards":"\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \"\u0627\u0644\u062a\u0627\u0644\u064a\" \u0644\u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0627\u062a VCard \u062c\u062f\u064a\u062f\u0629.","click_to_open_edit_sidebar":"\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \"\u0627\u0644\u062a\u0627\u0644\u064a\" \u0644\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0627\u0644\u0634\u0631\u064a\u0637 \u0627\u0644\u062c\u0627\u0646\u0628\u064a \u0644\u062a\u062d\u0631\u064a\u0631 VCard.","click_to_preview":"\u0627\u0646\u0642\u0631 \u0647\u0646\u0627 \u0644\u0645\u0639\u0627\u064a\u0646\u0629 VCard \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","click_to_save_vcard":"\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 \u0627\u0644\u062a\u0627\u0644\u064a \u0644\u062d\u0641\u0638 VCard \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","completed":"\u062a\u0645 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621","copied_successfully":"\u062a\u0645 \u0646\u0633\u062e \u0627\u0644\u0631\u0627\u0628\u0637 \u0628\u0646\u062c\u0627\u062d.","country":"\u0627\u0644\u062f\u0648\u0644\u0629","coupon_code":"\u0631\u0645\u0648\u0632 \u0627\u0644\u0642\u0633\u0627\u0626\u0645","coupon_code_apply":"\u062a\u0645 \u062a\u0637\u0628\u064a\u0642 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u0628\u0646\u062c\u0627\u062d.","coupon_code_percent_validation":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0643\u0648\u0646 \u062a\u062e\u0641\u064a\u0636 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u0623\u0643\u062b\u0631 \u0645\u0646 100\u066a.","custom":"\u0645\u062e\u0635\u0635","custom_link":"\u0631\u0627\u0628\u0637 \u0645\u062e\u0635\u0635","custom_vcard_number":"\u0631\u0642\u0645 \u0628\u0637\u0627\u0642\u0629 VCard \u0627\u0644\u0645\u062e\u0635\u0635\u0629","custom_vcard_price":"\u0628\u0637\u0627\u0642\u0629 VCard \u0645\u062e\u0635\u0635\u0629 \u0628\u062f\u0648\u0646 \u0633\u0639\u0631","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","delete":"\u062d\u0630\u0641","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641","description":"\u0623\u062f\u062e\u0644 \u0648\u0635\u0641 \u0628\u0637\u0627\u0642\u062a\u0643 \u0627\u0644\u0634\u062e\u0635\u064a\u0629","description_length":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0648\u0635\u0641 \u0644\u0627 \u064a\u0642\u0644 \u0639\u0646 3 \u0623\u062d\u0631\u0641.","description_required":"\u062d\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0645\u0637\u0644\u0648\u0628.","duplicate":"\u0645\u0643\u0631\u0631!","duplicate_vcard":"\u0628\u0637\u0627\u0642\u0629 \u0634\u062e\u0635\u064a\u0629 \u0645\u0643\u0631\u0631\u0629!","duplicate_vcard_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0629 \u0634\u062e\u0635\u064a\u0629 \u0645\u0643\u0631\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","email_required":"\u062d\u0642\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0637\u0644\u0648\u0628","embedtag":"\u062a\u0636\u0645\u064a\u0646 \u0627\u0644\u0639\u0644\u0627\u0645\u0629","enquiry":"\u0627\u0633\u062a\u0641\u0633\u0627\u0631","enter_valid_email":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0635\u0627\u0644\u062d.","enter_vcard_name":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0627\u0633\u0645 Vcard","error":"\u062e\u0637\u0623","faqs":"\u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","first_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644 \u0645\u0637\u0644\u0648\u0628.","flat":"\u0645\u0633\u062a\u0648\u0649","flutterwave_key":"\u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d Flutterwave \u0645\u0637\u0644\u0648\u0628.","flutterwave_secret":"\u062d\u0642\u0644 \u0633\u0631 Flutterwave \u0645\u0637\u0644\u0648\u0628.","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","from":"\u0645\u0646","front_image_field_required":"\u062d\u0642\u0644 \u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629 \u0645\u0637\u0644\u0648\u0628","gallery":"\u0645\u0639\u0631\u0636 \u0627\u0644\u0635\u0648\u0631","generate_url_alias":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u0646\u0634\u0627\u0621 \u0627\u0633\u0645 \u0645\u0633\u062a\u0639\u0627\u0631 \u0644\u0639\u0646\u0648\u0627\u0646 URL","has_been_completed":"\u062a\u0645 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621.","has_been_deleted":"\u062a\u0645 \u062d\u0630\u0641\u0647.","here_select_vcard_template":"\u0647\u0646\u0627 \u064a\u0645\u0643\u0646\u0643 \u062a\u062d\u062f\u064a\u062f \u0642\u0627\u0644\u0628 VCard \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","image_too_large":"\u0645\u0644\u0641\u0643 \u0643\u0628\u064a\u0631 \u062c\u062f\u064b\u0627. \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u0644\u062d\u062c\u0645 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647 \u0647\u0648 1 \u0645\u064a\u062c\u0627\u0628\u0627\u064a\u062a.","in_progress":"\u0642\u064a\u062f \u0627\u0644\u062a\u0646\u0641\u064a\u0630","inquries":"\u0633\u0624\u0627\u0644","invalid_country_code":"\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_number":"\u0631\u0642\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","last_30_days":"\u0627\u0644\u064030 \u064a\u0648\u0645 \u0627\u0644\u0623\u062e\u064a\u0631\u0629","last_7_days":"\u0627\u0644\u0623\u064a\u0627\u0645 \u0627\u0644\u0633\u0628\u0639\u0629 \u0627\u0644\u0645\u0627\u0636\u064a\u0629","last_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062e\u064a\u0631 \u0645\u0637\u0644\u0648\u0628.","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","loading":"\u062c\u0627\u0631 \u0627\u0644\u062a\u062d\u0645\u064a\u0644...","location_field_required":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0648\u0642\u0639 \u0645\u0637\u0644\u0648\u0628","logo_field_required":"\u062d\u0642\u0644 \u0634\u0639\u0627\u0631 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0645\u0637\u0644\u0648\u0628","logo_image_error":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0623\u0628\u0639\u0627\u062f \u0627\u0644\u0635\u0648\u0631\u0629 150x150 \u0628\u0643\u0633\u0644 \u0623\u0648 \u0623\u0642\u0644.","manual_payment_guide":"\u062f\u0644\u064a\u0644 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a","mar":"\u0645\u0627\u0631\u0633","may":"\u0645\u0627\u064a\u0648","mon":"\u0627\u0644\u0627\u062b\u0646\u064a\u0646","month":"\u0627\u0644\u0634\u0647\u0631","multi_templates":"\u0645\u0637\u0644\u0648\u0628 \u0642\u0648\u0627\u0644\u0628 \u0645\u062a\u0639\u062f\u062f\u0629","next":"\u0627\u0644\u062a\u0627\u0644\u064a","nfc_card":"\u0628\u0637\u0627\u0642\u0629 NFC","no":"\u0644\u0627","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","occupation_field_required":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0647\u0646\u0629 \u0645\u0637\u0644\u0648\u0628","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","ok":"\u062d\u0633\u0646\u0627","onesignal_app_id":"\u062d\u0642\u0644 \u0645\u0639\u0631\u0641 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u0641\u064a OneSignal \u0645\u0637\u0644\u0648\u0628.","onesignal_rest_api_key":"\u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d \u0648\u0627\u062c\u0647\u0629 \u0628\u0631\u0645\u062c\u0629 \u0627\u0644\u062a\u0637\u0628\u064a\u0642\u0627\u062a \u0641\u064a OneSignal \u0645\u0637\u0644\u0648\u0628.","password_character":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 8 \u0623\u062d","password_must_match":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0637\u0627\u0628\u0642 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0639 \u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631.","passwords":"\u062d\u0642\u0644 \u0643\u0644\u0645\u0627\u062a \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0637\u0644\u0648\u0628.","payment_not_complete":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621 \u0645\u0646 \u0639\u0645\u0644\u064a\u0629 \u0627\u0644\u062f\u0641\u0639","paypal_key":"\u062d\u0642\u0644 \u0645\u0639\u0631\u0641 \u0639\u0645\u064a\u0644 Paypal \u0645\u0637\u0644\u0648\u0628.","paypal_mode":"\u062d\u0642\u0644 \u0648\u0636\u0639 Paypal \u0645\u0637\u0644\u0648\u0628.","paypal_secret":"\u062d\u0642\u0644 \u0633\u0631 Paypal \u0645\u0637\u0644\u0648\u0628.","paystack_key":"\u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d Paystack \u0645\u0637\u0644\u0648\u0628.","paystack_secret":"\u062d\u0642\u0644 \u0633\u0631 Paystack \u0645\u0637\u0644\u0648\u0628.","phone":"\u0627\u0644\u0647\u0627\u062a\u0641","phone_number_required":"\u062d\u0642\u0644 \u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641 \u0645\u0637\u0644\u0648\u0628.","phonepe_env_required":"\u062d\u0642\u0644 Phonepe Env \u0645\u0637\u0644\u0648\u0628.","phonepe_merchant_id_required":"\u062d\u0642\u0644 \u0645\u0639\u0631\u0641 \u0627\u0644\u062a\u0627\u062c\u0631 Phonepe \u0645\u0637\u0644\u0648\u0628.","phonepe_merchant_transaction_id_required":"\u062d\u0642\u0644 \u0645\u0639\u0631\u0641 \u0645\u0639\u0627\u0645\u0644\u0629 \u062a\u0627\u062c\u0631 Phonepe \u0645\u0637\u0644\u0648\u0628.","phonepe_merchant_user_id_required":"\u062d\u0642\u0644 \u0645\u0639\u0631\u0641 \u0645\u0633\u062a\u062e\u062f\u0645 \u062a\u0627\u062c\u0631 Phonepe \u0645\u0637\u0644\u0648\u0628.","phonepe_salt_index_required":"\u062d\u0642\u0644 \u0645\u0624\u0634\u0631 \u0645\u0644\u062d \u0627\u0644\u0647\u0627\u062a\u0641 \u0645\u0637\u0644\u0648\u0628.","phonepe_salt_key_required":"\u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d \u0645\u0644\u062d \u0627\u0644\u0647\u0627\u062a\u0641 \u0645\u0637\u0644\u0648\u0628.","plan":"\u0627\u0644\u062e\u0637\u0629","plan_expire_notification":"\u062d\u0642\u0644 \u0625\u0634\u0639\u0627\u0631 \u0627\u0646\u062a\u0647\u0627\u0621 \u0627\u0644\u062e\u0637\u0629 \u0645\u0637\u0644\u0648\u0628.","please_select_user":"\u064a\u0631\u062c\u0649 \u0627\u062e\u062a\u064a\u0627\u0631 \u0645\u0633\u062a\u062e\u062f\u0645","please_wait":"\u064a\u0631\u062c\u0649 \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631...","privacy_policy":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629","product":"\u0645\u0646\u062a\u062c","provide_valid_wbsite_url":"\u0623\u062f\u062e\u0644 \u0631\u0627\u0628\u0637 \u0635\u062d\u064a\u062d","purchase":"\u0634\u0631\u0627\u0621","razorpay_key":"\u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d Rozorpay \u0645\u0637\u0644\u0648\u0628.","razorpay_secret":"\u062d\u0642\u0644 Rozorpay Secret \u0645\u0637\u0644\u0648\u0628.","rejected":"\u0645\u0631\u0641\u0648\u0636","remove":"\u0625\u0632\u0627\u0644\u0629","sat":"\u0627\u0644\u0633\u0628\u062a","select_all":"\u062d\u062f\u062f \u0627\u0644\u0643\u0644","select_email_required":"\u062d\u0642\u0644 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0645\u0637\u0644\u0648\u0628.","select_hour":"\u064a\u0631\u062c\u0649 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0623\u0648 \u0627\u0644\u0633\u0627\u0639\u0629","select_one_or_more":"\u062d\u062f\u062f \u0648\u0627\u062d\u062f \u0623\u0648 \u0623\u0643\u062b\u0631","select_payment_type":"\u0627\u062e\u062a\u0631 \u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639","select_user":"\u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","select_vcard":"\u062d\u062f\u062f Vcard","send_email_description":"\u0627\u0644\u0648\u0635\u0641","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","short_description":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0648\u0635\u0641 \u0627\u0644\u0642\u0635\u064a\u0631","skip":"\u064a\u062a\u062e\u0637\u0649","social_links_img_is_required":"\u0635\u0648\u0631\u0629 \u0631\u0648\u0627\u0628\u0637 \u0648\u0633\u0627\u0626\u0644 \u0627\u0644\u062a\u0648\u0627\u0635\u0644 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a \u0645\u0637\u0644\u0648\u0628\u0629.","social_links_is_required":"\u0631\u0648\u0627\u0628\u0637 \u0648\u0633\u0627\u0626\u0644 \u0627\u0644\u062a\u0648\u0627\u0635\u0644 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a \u0645\u0637\u0644\u0648\u0628\u0629.","state":"\u0627\u0644\u0648\u0644\u0627\u064a\u0629","stripe_key":"\u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d Stripe \u0645\u0637\u0644\u0648\u0628.","stripe_secret":"\u062d\u0642\u0644 \u0633\u0631 Stripe \u0645\u0637\u0644\u0648\u0628.","subject_required":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0648\u0636\u0648\u0639 \u0645\u0637\u0644\u0648\u0628.","subscriptions":"\u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643\u0627\u062a","successful":"\u0646\u0627\u062c\u062d","sun":"\u0627\u0644\u0623\u062d\u062f","term_condition":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645","testimonial":"\u0634\u0647\u0627\u062f\u0629","the_description_field_is_required":"\u062d\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0645\u0637\u0644\u0648\u0628.","the_term_conditions":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628\u0629.","this_is_analytics_chart":"\u0647\u0630\u0627 \u0647\u0648 \u0645\u062e\u0637\u0637 \u062a\u062d\u0644\u064a\u0644\u0627\u062a VCard \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0623\u0633\u0628\u0648\u0639","thu":"\u0627\u0644\u062e\u0645\u064a\u0633","to":"\u0625\u0644\u0649","today":"\u0627\u0644\u064a\u0648\u0645","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","unavailable":"\u063a\u064a\u0631 \u0645\u062a\u0627\u062d","upload_required":"\u062d\u0642\u0644 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0644\u0641 \u0645\u0637\u0644\u0648\u0628.","user":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","vcard":"\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","vcard_iframe":"\u0625\u0637\u0627\u0631 VCard","vcard_name":"\u0627\u0633\u0645 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0634\u062e\u0635\u064a\u0629","vcard_name_required":"\u062d\u0642\u0644 \u0627\u0633\u0645 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0645\u0637\u0644\u0648\u0628","vcard_service":"\u062e\u062f\u0645\u0629 VCard","vcard_testimonial":"\u0634\u0647\u0627\u062f\u0629 VCard","website_field_required":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0648\u0642\u0639 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0637\u0644\u0648\u0628","wed":"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621","yes":"\u0646\u0639\u0645","yesterday":"\u0627\u0644\u0623\u0645\u0633"},"de.js":{"Yes_Change":"Ja, Genehmigen","add_on":"Hinzuf\u00fcgen Auf","address_field":"Das Feld Adresse ist erforderlich.","admin":"Administrator","affiliation_amount_error":"Der Affiliationsbetrag darf 100% nicht \u00fcberschreiten","agree_term":"Sie m\u00fcssen den Nutzungsbedingungen zustimmen.","allowed_file_types":"Erlaubte Dateitypen: png, jpg, jpeg.","allowed_image":"Erlaubte Dateitypen: png, jpg, jpeg.","amount":"Betrag","app_name_required":"Das App-Namen-Feld ist erforderlich","apply":"Anwenden","appointment":"Termin","appointments":"Termine","approved":"Genehmigt","apr":"Apr","are_you_completed":"Sind Sie sicher, dass Sie dies genehmigen m\u00f6chten?","are_you_sure":"Sind Sie sicher, dass Sie dies l\u00f6schen m\u00f6chten","are_you_sure_dublicate_vcard":"Sind Sie sicher, dass Sie diese VCard duplizieren m\u00f6chten?","aug":"Aug","back_image_field_required":"R\u00fcckbildfeld ist erforderlich","blog":"Blog","blog_description":"Beschreibung","blog_image_required":"Das Feld \u201eBlog-Bild\u201c ist erforderlich.","cancel":"Abbrechen","check_email":"E-Mail existiert bereits.","choose_one_template":"W\u00e4hlen Sie eine Vorlage aus","choose_plan":"Plan ausw\u00e4hlen","city":"Stadt","click_open_sidebar":"Klicken Sie auf \u201eWeiter\u201c, um die Seitenleiste zu \u00f6ffnen.","click_to_add_vcard_name":"Klicken Sie hier, um Ihren Vcard-Namen hinzuzuf\u00fcgen.","click_to_create_vcards":"Klicken Sie auf Weiter, um Ihre VCard zu erstellen.","click_to_generate_alias":"Klicken Sie hier, um Ihren URL-Alias \u200b\u200bzu generieren.","click_to_go_dashboard":"Klicken Sie auf Weiter, um zum Dashboard zu gelangen.","click_to_make_vcards":"Klicken Sie auf \u201eWeiter\u201c, um neue VCards zu erstellen.","click_to_open_edit_sidebar":"Klicken Sie auf \u201eWeiter\u201c, um auf die VCard-Bearbeitungsseitenleiste zuzugreifen.","click_to_preview":"Klicken Sie hier, um eine Vorschau Ihrer VCard anzuzeigen.","click_to_save_vcard":"Klicken Sie auf Weiter, um Ihre VCard zu speichern.","completed":"Abgeschlossen","copied_successfully":"Link erfolgreich kopiert.","country":"Land","coupon_code":"Gutscheincode","coupon_code_apply":"Gutscheincode erfolgreich angewendet.","coupon_code_percent_validation":"Der Rabattcode darf nicht mehr als 100% betragen.","custom":"Benutzerdefiniert","custom_link":"Benutzerdefinierter Link","dec":"Dez","delete":"L\u00f6schen","deleted":"Gel\u00f6scht","description":"Beschreibung Ihrer VCard eingeben","description_length":"Die Beschreibung muss mindestens 3 Zeichen enthalten.","description_required":"Das Feld \u201eBeschreibung\u201c ist erforderlich.","duplicate":"Duplikat!","duplicate_vcard":"Duplizierte VCard!","duplicate_vcard_create":"Duplizierte VCard erfolgreich erstellt","email":"E-Mail","email_required":"Das E-Mail-Feld ist erforderlich","embedtag":"Tag einbetten","enquiry":"Anfrage","enter_valid_email":"Bitte geben Sie eine g\u00fcltige E-Mail-Adresse ein.","enter_vcard_name":"Bitte geben Sie einen Vcard-Namen ein","error":"Fehler","faqs":"FAQs","feb":"Feb","first_name_required":"Das Feld Vorname ist erforderlich.","flat":"Flach","flutterwave_key":"Das Flutterwave-Schl\u00fcsselfeld ist erforderlich.","flutterwave_secret":"Das Flutterwave-Geheimnisfeld ist erforderlich.","fri":"Fr","from":"Von","front_image_field_required":"Vorderbildfeld ist erforderlich","gallery":"Galerie","generate_url_alias":"Bitte generieren Sie einen URL-Alias","has_been_completed":"wurde abgeschlossen.","has_been_deleted":"wurde gel\u00f6scht.","here_select_vcard_template":"Hier k\u00f6nnen Sie Ihre VCard-Vorlage ausw\u00e4hlen.","image_too_large":"Ihre Datei ist zu gro\u00df. Die maximal zul\u00e4ssige Gr\u00f6\u00dfe betr\u00e4gt 1 MB.","in_progress":"In Bearbeitung","inquries":"Anfrage","invalid_country_code":"Ung\u00fcltiger L\u00e4ndercode","invalid_email":"E-Mail ist ung\u00fcltig","invalid_number":"Ung\u00fcltige Nummer","jan":"Jan","jul":"Jul","jun":"Jun","last_30_days":"Letzte 30 Tage","last_7_days":"Letzte 7 Tage","last_name_required":"Das Feld Nachname ist erforderlich.","last_week":"Letzte Woche","loading":"Laden...","location_field_required":"Standortfeld ist erforderlich","logo_field_required":"E-Card-Logo ist erforderlich","logo_image_error":"Die Bildabmessungen m\u00fcssen 150x150 Pixel oder kleiner sein.","manual_payment_guide":"Anleitung zur manuellen Zahlung","mar":"M\u00e4r","may":"Mai","mon":"Mo","month":"Monat","multi_templates":"Mehrere Vorlagen sind erforderlich","next":"N\u00e4chste","nfc_card":"NFC-Karte","no":"Nein","nov":"Nov","occupation_field_required":"Berufsfeld ist erforderlich","oct":"Okt","ok":"OK","onesignal_app_id":"Das Feld der OneSignal-App-ID ist erforderlich.","onesignal_rest_api_key":"Das Feld des OneSignal-REST-API-Schl\u00fcssels ist erforderlich.","password_character":"Das Passwort muss mindestens 8 Zeichen lang sein.","password_must_match":"Das Passwort und die Passwortbest\u00e4tigung m\u00fcssen \u00fcbereinstimmen.","passwords":"Das Passwortfeld ist erforderlich.","payment_not_complete":"Zahlung nicht abgeschlossen","paypal_key":"Das Feld \u201ePaypal-Kunden-ID\u201c ist erforderlich.","paypal_mode":"Das Feld PayPal-Modus ist erforderlich.","paypal_secret":"Das Feld PayPal Secret ist erforderlich.","paystack_key":"Das Paystack-Schl\u00fcsselfeld ist erforderlich.","paystack_secret":"Das Paystack-Geheimnisfeld ist erforderlich.","phone":"Telefon","phone_number_required":"Das Feld Telefonnummer ist erforderlich.","phonepe_env_required":"Das Feld Phonepe Env ist erforderlich.","phonepe_merchant_id_required":"Das Feld Phonepe-H\u00e4ndler-ID ist erforderlich.","phonepe_merchant_transaction_id_required":"Das Feld \u201ePhonepe-H\u00e4ndler-Transaktions-ID\u201c ist erforderlich.","phonepe_merchant_user_id_required":"Das Feld Phonepe-H\u00e4ndler-Benutzer-ID ist erforderlich.","phonepe_salt_index_required":"Das Feld \u201ePhonepe Salt Index\u201c ist erforderlich.","phonepe_salt_key_required":"Das Feld \u201ePhonepe Salt Key\u201c ist erforderlich.","plan":"Plan","plan_expire_notification":"Das Feld f\u00fcr die Benachrichtigung \u00fcber das Ablaufen des Plans ist erforderlich.","please_select_user":"Bitte w\u00e4hlen Sie einen Benutzer","please_wait":"Bitte warten...","privacy_policy":"Datenschutzrichtlinie","product":"Produkt","provide_valid_wbsite_url":"Bitte eine g\u00fcltige URL eingeben","purchase":"Kauf","razorpay_key":"Das Rozorpay-Schl\u00fcsselfeld ist erforderlich.","razorpay_secret":"Das Feld \u201eRozorpay-Geheimnis\u201c ist erforderlich.","rejected":"Abgelehnt","remove":"Entfernen","sat":"Sa","select_all":"Alles ausw\u00e4hlen","select_email_required":"Das Feld \u201eE-Mail senden\u201c ist erforderlich.","select_hour":"Bitte w\u00e4hlen Sie Datum oder Stunde","select_one_or_more":"W\u00e4hlen Sie eine oder mehrere Funktionen aus","select_payment_type":"W\u00e4hle eine Zahlmethode aus","select_user":"Benutzer ausw\u00e4hlen","select_vcard":"VCard auswhlen","send_email_description":"Beschreibung","sep":"Sep","short_description":"Geben Sie eine kurze Beschreibung ein","skip":"\u00dcberspringen","social_links_img_is_required":"Soziale Links Bild ist erforderlich.","social_links_is_required":"Soziale Links sind erforderlich.","state":"Bundesland","stripe_key":"Das Stripe-Schl\u00fcsselfeld ist erforderlich.","stripe_secret":"Das Feld Stripe Secret ist erforderlich.","subject_required":"Das Feld \u201eBetreff\u201c ist erforderlich.","subscriptions":"Abonnements","successful":"Erfolgreich","sun":"So","term_condition":"Nutzungsbedingungen","testimonial":"Referenz","the_term_conditions":"Die Nutzungsbedingungen sind erforderlich.","this_is_analytics_chart":"Dies ist Ihr VCard-Analysediagramm.","this_month":"Dieser Monat","this_week":"Diese Woche","thu":"Do","to":"Bis","today":"Heute","too_long":"Zu lang","too_short":"Zu kurz","tue":"Di","unavailable":"Nicht verf\u00fcgbar","upload_required":"Das Feld f\u00fcr den Dateiupload ist erforderlich.","user":"Benutzer","vcard":"VCard","vcard_iframe":"VCard iframe","vcard_name":"VCard-Name","vcard_name_required":"VCard-Name ist erforderlich","vcard_service":"VCard-Dienst","vcard_testimonial":"VCard-Testimonial","website_field_required":"Webseitenfeld ist erforderlich","wed":"Mi","yes":"Ja","yesterday":"Gestern"},"en.js":{"Yes_Change":"Yes, Approve","add_on":"Add On","address_field":"Address Field field is required.","admin":"Admin","affiliation_amount_error":"Affiliation amount cannot exceed 100%","agree_term":"You must agreed to Terms and conditions.","allowed_file_types":"Allowed file types: png, jpg, jpeg.","allowed_image":"Allowed file types: png, jpg, jpeg.","amount":"Amount","app_name_required":"App Name field is required","apply":"Apply","appointment":"Appointment","appointments":"Appointments","approved":"Approved","apr":"Apr","are_you_completed":"Are you sure, you want to approve this ?","are_you_sure":"Are you sure want to delete this","are_you_sure_dublicate_vcard":"Are you sure want to create duplicate  this VCard ?","aug":"Aug","back_image_field_required":"Back image field is required","blog":"Blog","blog_description":"Description","blog_image_required":"Blog image field is required.","cancel":"Cancel","check_email":"Email already exists.","choose_one_template":"Choose any one template","choose_plan":"Choose Plan","city":"City","click_open_sidebar":"Click on Next to Open Sidebar.","click_to_add_vcard_name":"Click Here to Add Your Vcard Name.","click_to_create_vcards":"Click on Next to Create Your VCard.","click_to_generate_alias":"Click Here to Generate Your URL Alias.","click_to_go_dashboard":"Click on Next to Proceed to Dashboard.","click_to_make_vcards":"Click on Next to Make New VCards.","click_to_open_edit_sidebar":"Click on Next to Access VCard Edit Sidebar.","click_to_preview":"Click Here to Preview Your VCard.","click_to_save_vcard":"Click on Next to Save Your VCard.","completed":"Completed","copied_successfully":"Link copied successfully.","country":"Country","coupon_code":"Coupon Codes","coupon_code_apply":"Coupon Code Applied successfully.","coupon_code_percent_validation":"Coupon discount should not be more than 100%.","custom":"Custom","custom_link":"Custom Link","custom_vcard_number":"Custom VCard No","custom_vcard_price":"Custom VCard No Price","dec":"Dec","delete":"Delete","deleted":"Deleted","description":"Enter Description of Your VCard","description_length":"The description must be at least 3 characters.","description_required":"Description field is required.","duplicate":"Duplicate !","duplicate_vcard":"Duplicate Vcard !","duplicate_vcard_create":"Duplicate Vcard created successfully","email":"Email","email_required":"Email field is required","embedtag":"Embed tag","enquiry":"Enquiry","enter_valid_email":"Please enter valid Email.","enter_vcard_name":"Please enter a Vcard Name","error":"Error","faqs":"FAQs","feb":"Feb","first_name_required":"First Name field is required.","flat":"Flat","flutterwave_key":"Flutterwave key field is required.","flutterwave_secret":"Flutterwave Secret field is required.","fri":"FRI","from":"From","front_image_field_required":"Front image field is required","gallery":"Gallery","generate_url_alias":"Please Generate a URL Alias","has_been_completed":"has been completed.","has_been_deleted":"has been deleted.","here_select_vcard_template":"Here You Can Select Your VCard Template.","image_too_large":"Your file is too large. Maximum size allowed is 1MB.","in_progress":"In Progress","inquries":"Inquiry","invalid_country_code":"Invalid country code","invalid_email":"Email is invalid","invalid_number":"Invalid Number","jan":"Jan","jul":"Jul","jun":"Jun","last_30_days":"Last 30 Day","last_7_days":"Last 7 Day","last_name_required":"Last Name field is required.","last_week":"Last Week","loading":"Loading...","location_field_required":"Location field is required","logo_field_required":"E-Card logo field is required","logo_image_error":"Image dimensions must be 150x150 pixels or less.","manual_payment_guide":"Manual Payment Guide","mar":"Mar","may":"May","mon":"MON","month":"Month","multi_templates":"Multi templates is required","next":"Next","nfc_card":"NFC Card","no":"No","nov":"Nov","occupation_field_required":"Occupation field is required","oct":"Oct","ok":"Ok","onesignal_app_id":"Onesignal App ID field is required.","onesignal_rest_api_key":"Onesignal Rest Api Key field is required.","password_character":"The password must be at least 8 characters.","password_must_match":"The password and password confirmation must match.","passwords":"The passwords field is required.","payment_not_complete":"Payment Not Completed","paypal_key":"Paypal Client ID field is required.","paypal_mode":"Paypal mode field is required.","paypal_secret":"Paypal secret field is required.","paystack_key":"Paystack key field is required.","paystack_secret":"Paystack Secret field is required.","phone":"Phone","phone_number_required":"Phone Number field is required.","phonepe_env_required":"Phonepe Env field is required.","phonepe_merchant_id_required":"Phonepe Merchant ID field is required.","phonepe_merchant_transaction_id_required":"Phonepe Merchant Transaction ID field is required.","phonepe_merchant_user_id_required":"Phonepe Merchant User ID field is required.","phonepe_salt_index_required":"Phonepe Salt Index field is required.","phonepe_salt_key_required":"Phonepe Salt Key field is required.","plan":"Plan","plan_expire_notification":"Plan Expire Notification field is required.","please_select_user":"Please select a user","please_wait":"Please Wait...","privacy_policy":"Privacy Policy","product":"Product","product_category":"Product Category","provide_valid_wbsite_url":"Enter must be valid url","purchase":"Purchase","razorpay_key":"Rozorpay key field is required.","razorpay_secret":"Rozorpay Secret field is required.","rejected":"Rejected","remove":"Remove","sat":"SAT","select_all":"Select All","select_email_required":"Send Mail field is required.","select_hour":"Please Select Date Or Hour","select_one_or_more":"Select one or more Feature is required","select_payment_type":"Select Payment Type","select_user":"Select User","select_vcard":"Select Vcard","send_email_description":"Description","sep":"Sep","short_description":"Enter Short Description","skip":"Skip","social_links_img_is_required":"Social links Image is required.","social_links_is_required":"Social links is required.","state":"State","stripe_key":"Stripe key field is required.","stripe_secret":"Stripe secret field is required.","subject_required":"Subject field is required.","subscriptions":"Subscriptions","successful":"Successful","sun":"SUN","term_condition":"Terms & Conditions","testimonial":"Testimonial","the_term_conditions":"The Terms & Conditions is required.","this_is_analytics_chart":"This is your VCard analytics Chart.","this_month":"This Month","this_week":"This Week","thu":"THU","to":"To","today":"Today","too_long":"Too long","too_short":"Too short","tue":"TUE","unavailable":"Unavailable","upload_required":"The file upload field is required.","user":"User","vcard":"VCard","vcard_iframe":"Vcard iframe","vcard_name":"VCard Name","vcard_name_required":"Vcard name field is required","vcard_service":"VCard Service","vcard_testimonial":"VCard Testimonial","website_field_required":"Website field is required","wed":"WED","whatsapp_store":"Whatsapp Store","yes":"Yes","yesterday":"Yesterday"},"es.js":{"Yes_Change":"S\u00ed, Aprobar","add_on":"A\u00f1adir","address_field":"El campo de direcci\u00f3n es obligatorio.","admin":"Administrador","affiliation_amount_error":"El monto de afiliaci\u00f3n no puede exceder el 100%","agree_term":"Debes estar de acuerdo con los t\u00e9rminos y condiciones.","allowed_file_types":"Tipos de archivo permitidos: png, jpg, jpeg.","allowed_image":"Tipos de archivo permitidos: png, jpg, jpeg.","amount":"Cantidad","app_name_required":"El campo de nombre de la aplicaci\u00f3n es obligatorio","apply":"Aplicar","appointment":"Cita","appointments":"Citas","approved":"Aprobado","apr":"Abr","are_you_completed":"\u00bfEst\u00e1s seguro de que deseas aprobar esto?","are_you_sure":"\u00bfEst\u00e1s seguro de que quieres eliminar esto?","are_you_sure_dublicate_vcard":"\u00bfEst\u00e1s seguro de que quieres duplicar esta VCard?","aug":"Ago","back_image_field_required":"El campo de la imagen posterior es obligatorio","blog":"Blog","blog_description":"Descripci\u00f3n","blog_image_required":"El campo de imagen del blog es obligatorio.","cancel":"Cancelar","check_email":"El Email ya existe.","choose_one_template":"Elige una plantilla","choose_plan":"Selecciona un plan","city":"Ciudad","click_open_sidebar":"Haga clic en Siguiente para abrir la barra lateral.","click_to_add_vcard_name":"Haga clic aqu\u00ed para agregar el nombre de su Vcard.","click_to_create_vcards":"Haga clic en Siguiente para crear su VCard.","click_to_generate_alias":"Haga clic aqu\u00ed para generar su alias de URL.","click_to_go_dashboard":"Haga clic en Siguiente para pasar al panel.","click_to_make_vcards":"Haga clic en Siguiente para crear nuevas VCards.","click_to_open_edit_sidebar":"Haga clic en Siguiente para acceder a la barra lateral de edici\u00f3n de VCard.","click_to_preview":"Haga clic aqu\u00ed para obtener una vista previa de su VCard.","click_to_save_vcard":"Haga clic en Siguiente para guardar su VCard.","completed":"Completado","copied_successfully":"Enlace copiado exitosamente.","country":"Pa\u00eds","coupon_code":"C\u00f3digos de cup\u00f3n","coupon_code_apply":"C\u00f3digo de cup\u00f3n aplicado con \u00e9xito.","coupon_code_percent_validation":"El descuento del cup\u00f3n no debe ser superior al 100%.","custom":"Personalizado","custom_link":"Enlace Personalizado","dec":"Dic","delete":"Eliminar","deleted":"Eliminado","description":"Ingresa la descripci\u00f3n de tu VCard","description_length":"La descripci\u00f3n debe tener al menos 3 caracteres.","description_required":"El campo de descripci\u00f3n es obligatorio.","duplicate":"Duplicado","duplicate_vcard":"VCard duplicada","duplicate_vcard_create":"VCard duplicada creada exitosamente","email":"Correo electr\u00f3nico","email_required":"El campo de correo electr\u00f3nico es obligatorio","embedtag":"Etiqueta de inserci\u00f3n","enquiry":"Consulta","enter_valid_email":"Por favor, ingresa un correo electr\u00f3nico v\u00e1lido.","enter_vcard_name":"Por favor ingrese un nombre de Vcard","error":"Error","faqs":"Preguntas frecuentes","feb":"Feb","first_name_required":"El campo de nombre es obligatorio.","flat":"Plano","flutterwave_key":"El campo de clave de Flutterwave es obligatorio.","flutterwave_secret":"El campo de secreto de Flutterwave es obligatorio.","fri":"VIE","from":"Desde","front_image_field_required":"El campo de la imagen frontal es obligatorio","gallery":"Galer\u00eda","generate_url_alias":"Por favor genere un alias de URL","has_been_completed":"ha sido completado.","has_been_deleted":"ha sido eliminado.","here_select_vcard_template":"Aqu\u00ed puede seleccionar su plantilla VCard.","image_too_large":"Su archivo es demasiado grande. El tama\u00f1o m\u00e1ximo permitido es 1 MB.","in_progress":"En progreso","inquries":"Consulta","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_email":"El correo electr\u00f3nico es inv\u00e1lido","invalid_number":"N\u00famero no v\u00e1lido","jan":"Ene","jul":"Jul","jun":"Jun","last_30_days":"\u00daltimos 30 d\u00edas","last_7_days":"\u00daltimos 7 d\u00edas","last_name_required":"El campo de apellido es obligatorio.","last_week":"Semana pasada","loading":"Cargando...","location_field_required":"El campo de ubicaci\u00f3n es obligatorio","logo_field_required":"El campo del logo de la tarjeta es obligatorio","logo_image_error":"Las dimensiones de la imagen deben ser 150x150 p\u00edxeles o menos.","manual_payment_guide":"Gu\u00eda de pago manual","mar":"Mar","may":"May","mon":"LUN","month":"Mes","multi_templates":"Se requieren varias plantillas","next":"Pr\u00f3xima","nfc_card":"Tarjeta NFC","no":"No","nov":"Nov","occupation_field_required":"El campo de ocupaci\u00f3n es obligatorio","oct":"Oct","ok":"Aceptar","onesignal_app_id":"El campo de ID de aplicaci\u00f3n de OneSignal es obligatorio.","onesignal_rest_api_key":"El campo de clave API REST de OneSignal es obligatorio.","password_character":"La contrase\u00f1a debe tener al menos 8 caracteres.","password_must_match":"La contrase\u00f1a y la confirmaci\u00f3n de la contrase\u00f1a deben coincidir.","passwords":"El campo de contrase\u00f1as es obligatorio.","payment_not_complete":"Pago no completado","paypal_key":"El campo ID de cliente de Paypal es obligatorio.","paypal_mode":"El campo de modo de PayPal es obligatorio.","paypal_secret":"El campo de secreto de PayPal es obligatorio.","paystack_key":"El campo de clave de Paystack es obligatorio.","paystack_secret":"El campo de secreto de Paystack es obligatorio.","phone":"Tel\u00e9fono","phone_number_required":"El campo de n\u00famero de tel\u00e9fono es obligatorio.","phonepe_env_required":"El campo Phonepe Env es obligatorio.","phonepe_merchant_id_required":"El campo ID de comerciante de Phonepe es obligatorio.","phonepe_merchant_transaction_id_required":"El campo ID de transacci\u00f3n del comerciante de Phonepe es obligatorio.","phonepe_merchant_user_id_required":"El campo de identificaci\u00f3n de usuario del comerciante de Phonepe es obligatorio.","phonepe_salt_index_required":"El campo \u00cdndice de sal de Phonepe es obligatorio.","phonepe_salt_key_required":"El campo Phonepe Salt Key es obligatorio.","plan":"Plan","plan_expire_notification":"El campo de notificaci\u00f3n de vencimiento del plan es obligatorio.","please_select_user":"Por favor, seleccione un usuario","please_wait":"Por favor espera...","privacy_policy":"Pol\u00edtica de privacidad","product":"Producto","provide_valid_wbsite_url":"Ingrese una URL v\u00e1lida","purchase":"Compra","razorpay_key":"El campo clave de Rozorpay es obligatorio.","razorpay_secret":"El campo secreto de Rozorpay es obligatorio.","rejected":"Rechazado","remove":"Eliminar","sat":"SAB","select_all":"Seleccionar todo","select_email_required":"El campo Enviar correo es obligatorio.","select_hour":"Por favor, selecciona fecha u hora","select_one_or_more":"Selecciona una o m\u00e1s funciones requeridas","select_payment_type":"Seleccione el tipo de pago","select_user":"Seleccionar usuario","select_vcard":"Seleccione Vcard","send_email_description":"Descripci\u00f3n","sep":"Sep","short_description":"Ingresa una descripci\u00f3n corta","skip":"Saltar","social_links_img_is_required":"Se requiere la imagen de enlaces sociales.","social_links_is_required":"Se requieren enlaces sociales.","state":"Estado","stripe_key":"Se requiere el campo de clave de Stripe.","stripe_secret":"El campo de secreto de Stripe es obligatorio.","subject_required":"El campo Asunto es obligatorio.","subscriptions":"Suscripciones","successful":"Exitoso","sun":"DOM","term_condition":"T\u00e9rminos y condiciones","testimonial":"Testimonio","the_term_conditions":"Se requieren los t\u00e9rminos y condiciones.","this_is_analytics_chart":"Este es su gr\u00e1fico de an\u00e1lisis de VCard.","this_month":"Este Mes","this_week":"Esta semana","thu":"JUE","to":"Hasta","today":"Hoy","too_long":"Demasiado largo","too_short":"Demasiado corto","tue":"MAR","unavailable":"No disponible","upload_required":"El campo de carga de archivos es obligatorio.","user":"Usuario","vcard":"VCard","vcard_iframe":"Iframe de VCard","vcard_name":"Nombre de la VCard","vcard_name_required":"El campo de nombre de la tarjeta es obligatorio","vcard_service":"Servicio de VCard","vcard_testimonial":"Testimonio de VCard","website_field_required":"El campo de sitio web es obligatorio","wed":"MIE","yes":"S\u00ed","yesterday":"Ayer"},"fr.js":{"Yes_Change":"Oui, Approuver","add_on":"Ajouter","address_field":"Le champ Adresse est requis.","admin":"Admin","affiliation_amount_error":"Le montant de l'affiliation ne peut pas d\u00e9passer 100%","agree_term":"Vous devez accepter les termes et conditions.","allowed_file_types":"Types de fichiers autoris\u00e9s : png, jpg, jpeg.","allowed_image":"Types de fichiers autoris\u00e9s : png, jpg, jpeg.","amount":"Montant","app_name_required":"Le champ Nom de l'application est requis","apply":"Appliquer","appointment":"Rendez-vous","appointments":"Rendez-vous","approved":"Approuv\u00e9","apr":"Avr","are_you_completed":"\u00cates-vous s\u00fbr de vouloir approuver ceci ?","are_you_sure":"\u00cates-vous s\u00fbr de vouloir supprimer ceci","are_you_sure_dublicate_vcard":"\u00cates-vous s\u00fbr de vouloir cr\u00e9er une copie de cette VCard ?","aug":"Ao\u00fbt","back_image_field_required":"Le champ de l'image arri\u00e8re est requis","blog":"Blog","blog_description":"Description","blog_image_required":"Le champ Image du blog est obligatoire.","cancel":"Annuler","check_email":"L'email existe d\u00e9j\u00e0.","choose_one_template":"Choisissez un mod\u00e8le","choose_plan":"Choisissez un plan","city":"Ville","click_open_sidebar":"Cliquez sur Suivant pour ouvrir la barre lat\u00e9rale.","click_to_add_vcard_name":"Cliquez ici pour ajouter votre nom de Vcard.","click_to_create_vcards":"Cliquez sur Suivant pour cr\u00e9er votre VCard.","click_to_generate_alias":"Cliquez ici pour g\u00e9n\u00e9rer votre alias d'URL.","click_to_go_dashboard":"Cliquez sur Suivant pour acc\u00e9der au tableau de bord.","click_to_make_vcards":"Cliquez sur Suivant pour cr\u00e9er de nouvelles VCards.","click_to_open_edit_sidebar":"Cliquez sur Suivant pour acc\u00e9der \u00e0 la barre lat\u00e9rale d'\u00e9dition de VCard.","click_to_preview":"Cliquez ici pour pr\u00e9visualiser votre VCard.","click_to_save_vcard":"Cliquez sur Suivant pour enregistrer votre VCard.","completed":"Termin\u00e9","copied_successfully":"Lien copi\u00e9 avec succ\u00e8s.","country":"Pays","coupon_code":"Codes de coupon","coupon_code_apply":"Code promo appliqu\u00e9 avec succ\u00e8s.","coupon_code_percent_validation":"La r\u00e9duction du coupon ne doit pas \u00eatre sup\u00e9rieure \u00e0 100%.","custom":"Personnalis\u00e9","custom_link":"Lien Personnalis\u00e9","dec":"D\u00e9c","delete":"Supprimer","deleted":"Supprim\u00e9","description":"Entrez la description de votre VCard","description_length":"La description doit comporter au moins 3 caract\u00e8res.","description_required":"Le champ Description est obligatoire.","duplicate":"Dupliqu\u00e9 !","duplicate_vcard":"VCard dupliqu\u00e9e !","duplicate_vcard_create":"VCard dupliqu\u00e9e cr\u00e9\u00e9e avec succ\u00e8s","email":"E-mail","email_required":"Le champ email est obligatoire","embedtag":"Incorporer une balise","enquiry":"Demande","enter_valid_email":"Veuillez entrer une adresse e-mail valide.","enter_vcard_name":"Veuillez entrer un nom de Vcard","error":"Erreur","faqs":"FAQs","feb":"F\u00e9v","first_name_required":"Le champ Pr\u00e9nom est requis.","flat":"\u00c0 plat","flutterwave_key":"Le champ de cl\u00e9 Flutterwave est requis.","flutterwave_secret":"Le champ de secret Flutterwave est requis.","fri":"VEN","from":"De","front_image_field_required":"Le champ de l'image avant est requis","gallery":"Galerie","generate_url_alias":"Veuillez g\u00e9n\u00e9rer un alias d'URL","has_been_completed":"a \u00e9t\u00e9 termin\u00e9.","has_been_deleted":"a \u00e9t\u00e9 supprim\u00e9.","here_select_vcard_template":"Ici, vous pouvez s\u00e9lectionner votre mod\u00e8le de VCard.","image_too_large":"Votre fichier est trop volumineux. La taille maximale autoris\u00e9e est de 1 Mo.","in_progress":"En cours","inquries":"Enqu\u00eate","invalid_country_code":"Code pays invalide","invalid_email":"L'email est invalide","invalid_number":"Num\u00e9ro invalide","jan":"Jan","jul":"Juil","jun":"Juin","last_30_days":"Les 30 derniers jours","last_7_days":"Les 7 derniers jours","last_name_required":"Le champ Nom de famille est requis.","last_week":"La semaine derni\u00e8re","loading":"Chargement...","location_field_required":"Le champ de localisation est requis","logo_field_required":"Le champ du logo de la carte est requis","logo_image_error":"Les dimensions de l'image doivent \u00eatre de 150x150 pixels ou moins.","manual_payment_guide":"Guide de paiement manuel","mar":"Mar","may":"Mai","mon":"LUN","month":"Mois","multi_templates":"Plusieurs mod\u00e8les sont requis","next":"Suivante","nfc_card":"Carte NFC","no":"Non","nov":"Nov","occupation_field_required":"Le champ de profession est requis","oct":"Oct","ok":"OK","onesignal_app_id":"Le champ de l\\'identifiant de l\\'application OneSignal est requis.","onesignal_rest_api_key":"Le champ de cl\u00e9 API REST de OneSignal est requis.","password_character":"Le mot de passe doit comporter au moins 8 caract\u00e8res.","password_must_match":"Le mot de passe et la confirmation du mot de passe doivent correspondre.","passwords":"Le champ Mots de passe est requis.","payment_not_complete":"Paiement non termin\u00e9","paypal_key":"Le champ ID client Paypal est obligatoire.","paypal_mode":"Le champ Mode PayPal est requis.","paypal_secret":"Le champ Secret PayPal est requis.","paystack_key":"Le champ de cl\u00e9 Paystack est requis.","paystack_secret":"Le champ de secret Paystack est requis.","phone":"T\u00e9l\u00e9phone","phone_number_required":"Le champ Num\u00e9ro de t\u00e9l\u00e9phone est requis.","phonepe_env_required":"Le champ Phonepe Env est obligatoire.","phonepe_merchant_id_required":"Le champ Identifiant du marchand Phonepe est obligatoire.","phonepe_merchant_transaction_id_required":"Le champ Identifiant de transaction du marchand Phonepe est obligatoire.","phonepe_merchant_user_id_required":"Le champ Identifiant de l'utilisateur du commer\u00e7ant Phonepe est obligatoire.","phonepe_salt_index_required":"Le champ Phonepe Salt Index est obligatoire.","phonepe_salt_key_required":"Le champ Phonepe Salt Key est obligatoire.","plan":"Plan","plan_expire_notification":"Le champ Notification d'expiration du plan est requis.","please_select_user":"Veuillez s\u00e9lectionner un utilisateur","please_wait":"Veuillez patienter...","privacy_policy":"Politique de confidentialit\u00e9","product":"Produit","provide_valid_wbsite_url":"Veuillez entrer une URL valide","purchase":"Achat","razorpay_key":"Le champ cl\u00e9 Rozorpay est obligatoire.","razorpay_secret":"Le champ Rozorpay Secret est obligatoire.","rejected":"Rejet\u00e9","remove":"Supprimer","sat":"SAM","select_all":"S\u00e9lectionner tout","select_email_required":"Le champ Envoyer un courrier est obligatoire.","select_hour":"Veuillez s\u00e9lectionner la date ou l'heure","select_one_or_more":"S\u00e9lectionnez une ou plusieurs fonctionnalit\u00e9s requises","select_payment_type":"S\u00e9lectionnez le type de paiement","select_user":"S\u00e9lectionner l'utilisateur","select_vcard":"S\u00e9lectionnez la carte virtuelle","send_email_description":"Description","sep":"Sep","short_description":"Entrez une courte description","skip":"Sauter","social_links_img_is_required":"L'image des liens sociaux est requise.","social_links_is_required":"Les liens sociaux sont requis.","state":"\u00c9tat","stripe_key":"Le champ cl\u00e9 Stripe est requis.","stripe_secret":"Le champ Secret Stripe est requis.","subject_required":"Le champ Objet est obligatoire.","subscriptions":"Abonnements","successful":"R\u00e9ussi","sun":"DIM","term_condition":"Conditions g\u00e9n\u00e9rales","testimonial":"T\u00e9moignage","the_term_conditions":"Les conditions g\u00e9n\u00e9rales sont requises.","this_is_analytics_chart":"Ceci est votre graphique d'analyse VCard.","this_month":"Ce mois-ci","this_week":"Cette semaine","thu":"JEU","to":"\u00c0","today":"Aujourd'hui","too_long":"Trop long","too_short":"Trop court","tue":"MAR","unavailable":"Indisponible","upload_required":"Le champ de t\u00e9l\u00e9chargement de fichier est requis.","user":"Utilisateur","vcard":"VCard","vcard_iframe":"Iframe VCard","vcard_name":"Nom de la VCard","vcard_name_required":"Le champ du nom de la carte est requis","vcard_service":"Service VCard","vcard_testimonial":"T\u00e9moignage VCard","website_field_required":"Le champ du site Web est requis","wed":"MER","yes":"Oui","yesterday":"Hier"},"hi.js":{"Yes_Change":"\u0939\u093e\u0901, \u0938\u094d\u0935\u0940\u0915\u0943\u0924 \u0915\u0930\u0947\u0902","add_on":"\u0910\u0921 \u0911\u0928","address_field":"\u092a\u0924\u093e \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","admin":"\u0935\u094d\u092f\u0935\u0938\u094d\u0925\u093e\u092a\u0915","affiliation_amount_error":"\u0938\u0902\u092c\u0926\u094d\u0927\u0924\u093e \u0930\u093e\u0936\u093f 100% \u0938\u0947 \u0905\u0927\u093f\u0915 \u0928\u0939\u0940\u0902 \u0939\u094b \u0938\u0915\u0924\u0940\u0964","agree_term":"\u0906\u092a\u0915\u094b \u0936\u0930\u094d\u0924\u094b\u0902 \u0914\u0930 \u0928\u093f\u092f\u092e\u094b\u0902 \u0938\u0947 \u0938\u0939\u092e\u0924 \u0939\u094b\u0928\u093e \u0939\u094b\u0917\u093e\u0964","allowed_file_types":"\u0905\u0928\u0941\u092e\u0924 \u092b\u093c\u093e\u0907\u0932 \u092a\u094d\u0930\u0915\u093e\u0930: png, jpg, jpeg\u0964","allowed_image":"\u0905\u0928\u0941\u092e\u0924 \u092b\u093c\u093e\u0907\u0932 \u092a\u094d\u0930\u0915\u093e\u0930: png, jpg, jpeg\u0964","amount":"\u0930\u093e\u0936\u093f","app_name_required":"\u0910\u092a \u0915\u093e \u0928\u093e\u092e \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948","apply":"\u0932\u093e\u0917\u0942 \u0915\u0930\u0947\u0902","appointment":"\u0928\u093f\u092f\u0941\u0915\u094d\u0924\u093f","appointments":"\u0928\u093f\u092f\u0941\u0915\u094d\u0924\u093f\u092f\u093e\u0901","approved":"\u0938\u094d\u0935\u0940\u0915\u0943\u0924","apr":"\u0905\u092a\u094d\u0930\u0948\u0932","are_you_completed":"\u0915\u094d\u092f\u093e \u0906\u092a \u0938\u0941\u0928\u093f\u0936\u094d\u091a\u093f\u0924 \u0939\u0948\u0902 \u0915\u093f \u0906\u092a \u0907\u0938\u0947 \u0938\u094d\u0935\u0940\u0915\u0943\u0924 \u0915\u0930\u0928\u093e \u091a\u093e\u0939\u0924\u0947 \u0939\u0948\u0902?","are_you_sure":"\u0915\u094d\u092f\u093e \u0906\u092a \u0938\u0941\u0928\u093f\u0936\u094d\u091a\u093f\u0924 \u0939\u0948\u0902 \u0915\u093f \u0906\u092a \u0907\u0938\u0947 \u0939\u091f\u093e\u0928\u093e \u091a\u093e\u0939\u0924\u0947 \u0939\u0948\u0902","are_you_sure_dublicate_vcard":"\u0915\u094d\u092f\u093e \u0906\u092a \u0938\u0941\u0928\u093f\u0936\u094d\u091a\u093f\u0924 \u0939\u0948\u0902 \u0915\u093f \u0906\u092a \u0907\u0938 \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0915\u094b \u0921\u0941\u092a\u094d\u0932\u093f\u0915\u0947\u091f \u0915\u0930\u0928\u093e \u091a\u093e\u0939\u0924\u0947 \u0939\u0948\u0902?","are_you_sure_want_to_delete_selected_Vcards":"\u0915\u094d\u092f\u093e \u0906\u092a \u0938\u0941\u0928\u093f\u0936\u094d\u091a\u093f\u0924 \u0939\u0948\u0902 \u0915\u093f \u0906\u092a \u091a\u092f\u0928\u093f\u0924 \"\u0935\u0940\u0915\u093e\u0930\u094d\u0921\" \u0915\u094b \u0939\u091f\u093e\u0928\u093e \u091a\u093e\u0939\u0924\u0947 \u0939\u0948\u0902?","aug":"\u0905\u0917\u0938\u094d\u0924","back_image_field_required":"\u092a\u0940\u091b\u0947 \u0915\u0940 \u091b\u0935\u093f \u0915\u093e \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u0905\u0928\u093f\u0935\u093e\u0930\u094d\u092f \u0939\u0948","blog":"\u092c\u094d\u0932\u0949\u0917","blog_description":"\u0935\u093f\u0935\u0930\u0923","blog_image_required":"\u092c\u094d\u0932\u0949\u0917 \u091b\u0935\u093f \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","cancel":"\u0930\u0926\u094d\u0926 \u0915\u0930\u0947\u0902","check_email":"\u0908\u092e\u0947\u0932 \u092a\u0939\u0932\u0947 \u0938\u0947 \u092e\u094c\u091c\u0942\u0926 \u0939\u0948\u0964","choose_one_template":"\u0915\u0943\u092a\u092f\u093e \u0915\u094b\u0908 \u090f\u0915 \u091f\u0947\u092e\u094d\u092a\u094d\u0932\u0947\u091f \u091a\u0941\u0928\u0947\u0902","choose_plan":"\u092f\u094b\u091c\u0928\u093e \u091a\u0941\u0928\u0947\u0902","city":"\u0936\u0939\u0930","click_open_sidebar":"\u0938\u093e\u0907\u0921\u092c\u093e\u0930 \u0916\u094b\u0932\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u0905\u0917\u0932\u093e \u092a\u0930 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","click_to_add_vcard_name":"\u0905\u092a\u0928\u093e \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0928\u093e\u092e \u091c\u094b\u0921\u093c\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u092f\u0939\u093e\u0901 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","click_to_create_vcards":"\u0905\u092a\u0928\u0947 \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u092c\u0928\u093e\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u0905\u0917\u0932\u093e \u092a\u0930 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","click_to_generate_alias":"\u0905\u092a\u0928\u093e \u092f\u0942\u0906\u0930\u090f\u0932 \u0909\u092a\u0928\u093e\u092e \u091c\u0928\u0930\u0947\u091f \u0915\u0930\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u092f\u0939\u093e\u0901 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","click_to_go_dashboard":"\u0921\u0948\u0936\u092c\u094b\u0930\u094d\u0921 \u092a\u0930 \u091c\u093e\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u0905\u0917\u0932\u093e \u092a\u0930 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","click_to_make_vcards":"\u0928\u090f \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u092c\u0928\u093e\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u0905\u0917\u0932\u093e \u092a\u0930 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","click_to_open_edit_sidebar":"\u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0938\u0902\u092a\u093e\u0926\u0928 \u0938\u093e\u0907\u0921\u092c\u093e\u0930 \u0924\u0915 \u092a\u0939\u0941\u0901\u091a\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u0905\u0917\u0932\u093e \u092a\u0930 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","click_to_preview":"\u0905\u092a\u0928\u0947 \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0915\u093e \u092a\u0942\u0930\u094d\u0935\u093e\u0935\u0932\u094b\u0915\u0928 \u0915\u0930\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u092f\u0939\u093e\u0901 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","click_to_save_vcard":"\u0905\u092a\u0928\u0947 \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0915\u094b \u0938\u0939\u0947\u091c\u0928\u0947 \u0915\u0947 \u0932\u093f\u090f \u0905\u0917\u0932\u093e \u092a\u0930 \u0915\u094d\u0932\u093f\u0915 \u0915\u0930\u0947\u0902\u0964","completed":"\u092a\u0942\u0930\u094d\u0923","copied_successfully":"\u0932\u093f\u0902\u0915 \u0938\u092b\u0932\u0924\u093e\u092a\u0942\u0930\u094d\u0935\u0915 \u0915\u0949\u092a\u0940 \u0939\u094b \u0917\u092f\u093e\u0964","country":"\u0926\u0947\u0936","coupon_code":"\u0915\u0942\u092a\u0928 \u0915\u094b\u0921","coupon_code_apply":"\u0915\u0942\u092a\u0928 \u0915\u094b\u0921 \u0938\u092b\u0932\u0924\u093e\u092a\u0942\u0930\u094d\u0935\u0915 \u0932\u093e\u0917\u0942 \u0915\u093f\u092f\u093e \u0917\u092f\u093e\u0964","coupon_code_percent_validation":"\u0915\u0942\u092a\u0928 \u091b\u0942\u091f 100% \u0938\u0947 \u0905\u0927\u093f\u0915 \u0928\u0939\u0940\u0902 \u0939\u094b\u0928\u0940 \u091a\u093e\u0939\u093f\u090f\u0964","custom":"\u0915\u0938\u094d\u091f\u092e","custom_link":"\u0915\u0938\u094d\u091f\u092e \u0932\u093f\u0902\u0915","custom_vcard_number":"\u0915\u0938\u094d\u091f\u092e \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0928\u0902\u092c\u0930","custom_vcard_price":"\u0915\u0938\u094d\u091f\u092e \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0928\u0902\u092c\u0930 \u092e\u0942\u0932\u094d\u092f","dec":"\u0926\u093f\u0938\u0902\u092c\u0930","default_plan":"\u0921\u093f\u092b\u093c\u0949\u0932\u094d\u091f \u092f\u094b\u091c\u0928\u093e","delete":"\u0939\u091f\u093e\u090f\u0901","deleted":"\u0939\u091f\u093e\u092f\u093e \u0917\u092f\u093e","description":"\u0905\u092a\u0928\u0947 \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0915\u093e \u0935\u093f\u0935\u0930\u0923 \u0926\u0930\u094d\u091c \u0915\u0930\u0947\u0902","description_length":"\u0935\u093f\u0935\u0930\u0923 \u092e\u0947\u0902 \u0915\u092e \u0938\u0947 \u0915\u092e 3 \u0935\u0930\u094d\u0923 \u0939\u094b\u0928\u0947 \u091a\u093e\u0939\u093f\u090f\u0964","description_required":"\u0935\u093f\u0935\u0930\u0923 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","duplicate":"\u0921\u0941\u092a\u094d\u0932\u093f\u0915\u0947\u091f!","duplicate_vcard":"\u0921\u0941\u092a\u094d\u0932\u093f\u0915\u0947\u091f \u0935\u0940\u0915\u093e\u0930\u094d\u0921!","duplicate_vcard_create":"\u0921\u0941\u092a\u094d\u0932\u093f\u0915\u0947\u091f \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0938\u092b\u0932\u0924\u093e\u092a\u0942\u0930\u094d\u0935\u0915 \u092c\u0928\u093e\u092f\u093e \u0917\u092f\u093e","email":"\u0908\u092e\u0947\u0932","email_required":"\u0908\u092e\u0947\u0932 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","embedtag":"\u091f\u0948\u0917 \u090f\u092e\u094d\u092c\u0947\u0921 \u0915\u0930\u0947\u0902","enquiry":"\u092a\u0942\u091b\u0924\u093e\u091b","enter_valid_email":"\u0915\u0943\u092a\u092f\u093e \u092e\u093e\u0928\u094d\u092f \u0908\u092e\u0947\u0932 \u0926\u0930\u094d\u091c \u0915\u0930\u0947\u0902\u0964","enter_vcard_name":"\u0915\u0943\u092a\u092f\u093e \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0928\u093e\u092e \u0926\u0930\u094d\u091c \u0915\u0930\u0947\u0902","error":"\u0924\u094d\u0930\u0941\u091f\u093f","faqs":"\u0938\u093e\u092e\u093e\u0928\u094d\u092f \u092a\u094d\u0930\u0936\u094d\u0928","feb":"\u092b\u0930","first_name_required":"\u092a\u0939\u0932\u093e \u0928\u093e\u092e \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","flat":"\u092b\u094d\u0932\u0948\u091f","flutterwave_key":"\u092b\u093c\u094d\u0932\u091f\u0930\u0935\u0947\u0935 \u0915\u0941\u0902\u091c\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","flutterwave_secret":"\u092b\u093c\u094d\u0932\u091f\u0930\u0935\u0947\u0935 \u0938\u0940\u0915\u094d\u0930\u0947\u091f \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","fri":"\u0936\u0941\u0915\u094d\u0930","from":"\u0938\u0947","front_image_field_required":"\u0938\u093e\u092e\u0928\u0947 \u0915\u0940 \u091b\u0935\u093f \u0915\u093e \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u0905\u0928\u093f\u0935\u093e\u0930\u094d\u092f \u0939\u0948","gallery":"\u0917\u0948\u0932\u0930\u0940","generate_url_alias":"\u0915\u0943\u092a\u092f\u093e \u090f\u0915 \u092f\u0942\u0906\u0930\u090f\u0932 \u0909\u092a\u0928\u093e\u092e \u091c\u0928\u0930\u0947\u091f \u0915\u0930\u0947\u0902","has_been_completed":"\u092a\u0942\u0930\u093e \u0939\u094b \u0917\u092f\u093e \u0939\u0948\u0964","has_been_deleted":"\u0939\u091f\u093e \u0926\u093f\u092f\u093e \u0917\u092f\u093e \u0939\u0948\u0964","here_select_vcard_template":"\u092f\u0939\u093e\u0901 \u0906\u092a \u0905\u092a\u0928\u093e \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u091f\u0947\u092e\u094d\u092a\u0932\u0947\u091f \u091a\u0941\u0928 \u0938\u0915\u0924\u0947 \u0939\u0948\u0902\u0964","image_too_large":"\u0906\u092a\u0915\u0940 \u092b\u093c\u093e\u0907\u0932 \u092c\u0939\u0941\u0924 \u092c\u0921\u093c\u0940 \u0939\u0948. \u0905\u0927\u093f\u0915\u0924\u092e \u0905\u0928\u0941\u092e\u0924 \u0906\u0915\u093e\u0930 1MB \u0939\u0948.","in_progress":"\u092a\u094d\u0930\u0917\u0924\u093f \u092e\u0947\u0902","inquries":"\u0905\u0928\u0941\u0938\u0902\u0927\u093e\u0928","invalid_country_code":"\u0905\u092e\u093e\u0928\u094d\u092f \u0926\u0947\u0936 \u0915\u094b\u0921","invalid_email":"\u0908\u092e\u0947\u0932 \u0905\u092e\u093e\u0928\u094d\u092f \u0939\u0948","invalid_number":"\u0905\u092e\u093e\u0928\u094d\u092f \u0938\u0902\u0916\u094d\u092f\u093e","jan":"\u091c\u0928","jul":"\u091c\u0941\u0932\u093e\u0908","jun":"\u091c\u0942\u0928","last_30_days":"\u092a\u093f\u091b\u0932\u0947 30 \u0926\u093f\u0928","last_7_days":"\u092a\u093f\u091b\u0932\u0947 7 \u0926\u093f\u0928","last_name_required":"\u0905\u0902\u0924\u093f\u092e \u0928\u093e\u092e \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","last_week":"\u092a\u093f\u091b\u0932\u0947 \u0938\u092a\u094d\u0924\u093e\u0939","loading":"\u0932\u094b\u0921 \u0939\u094b \u0930\u0939\u093e \u0939\u0948...","location_field_required":"\u0938\u094d\u0925\u093e\u0928 \u0915\u093e \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u0905\u0928\u093f\u0935\u093e\u0930\u094d\u092f \u0939\u0948","logo_field_required":"\u0908-\u0915\u093e\u0930\u094d\u0921 \u0932\u094b\u0917\u094b \u0915\u093e \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u0905\u0928\u093f\u0935\u093e\u0930\u094d\u092f \u0939\u0948","logo_image_error":"\u091b\u0935\u093f \u0915\u093e \u0906\u0915\u093e\u0930 150x150 \u092a\u093f\u0915\u094d\u0938\u0947\u0932 \u092f\u093e \u0909\u0938\u0938\u0947 \u0915\u092e \u0939\u094b\u0928\u093e \u091a\u093e\u0939\u093f\u090f\u0964","manual_payment_guide":"\u092e\u0948\u0928\u0941\u0905\u0932 \u092d\u0941\u0917\u0924\u093e\u0928 \u0917\u093e\u0907\u0921","mar":"\u092e\u093e\u0930\u094d\u091a","may":"\u092e\u0908","mon":"\u0938\u094b\u092e","month":"\u092e\u0939\u0940\u0928\u093e","multi_templates":"\u092e\u0932\u094d\u091f\u0940 \u091f\u0947\u092e\u094d\u092a\u094d\u0932\u0947\u091f\u094d\u0938 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0902","next":"\u0905\u0917\u0932\u093e","nfc_card":"\u090f\u0928\u090f\u092b\u0938\u0940 \u0915\u093e\u0930\u094d\u0921","no":"\u0928\u0939\u0940\u0902","nov":"\u0928\u0935\u0902\u092c\u0930","occupation_field_required":"\u0935\u094d\u092f\u0935\u0938\u093e\u092f \u0915\u093e \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u0905\u0928\u093f\u0935\u093e\u0930\u094d\u092f \u0939\u0948","oct":"\u0905\u0915\u094d\u091f\u0942\u092c\u0930","ok":"\u0920\u0940\u0915 \u0939\u0948","onesignal_app_id":"OneSignal \u0910\u092a \u0906\u0908\u0921\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","onesignal_rest_api_key":"OneSignal \u0930\u0947\u0938\u094d\u091f \u090f\u092a\u0940\u0906\u0908 \u0915\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","password_character":"\u092a\u093e\u0938\u0935\u0930\u094d\u0921 \u092e\u0947\u0902 \u0915\u092e \u0938\u0947 \u0915\u092e 8 \u0935\u0930\u094d\u0923 \u0939\u094b\u0928\u0947 \u091a\u093e\u0939\u093f\u090f\u0964","password_must_match":"\u092a\u093e\u0938\u0935\u0930\u094d\u0921 \u0914\u0930 \u092a\u093e\u0938\u0935\u0930\u094d\u0921 \u092a\u0941\u0937\u094d\u091f\u093f \u092e\u0947\u0932 \u0916\u093e\u0928\u093e \u091a\u093e\u0939\u093f\u090f\u0964","passwords":"\u092a\u093e\u0938\u0935\u0930\u094d\u0921 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","payment_not_complete":"\u092d\u0941\u0917\u0924\u093e\u0928 \u092a\u0942\u0930\u093e \u0928\u0939\u0940\u0902 \u0939\u0941\u0906","paypal_key":"PayPal \u0915\u094d\u0932\u093e\u0907\u0902\u091f \u0906\u0908\u0921\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","paypal_mode":"PayPal \u092e\u094b\u0921 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","paypal_secret":"PayPal \u0938\u0940\u0915\u094d\u0930\u0947\u091f \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","paystack_key":"\u092a\u0947\u0938\u094d\u091f\u0948\u0915 \u0915\u0941\u0902\u091c\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","paystack_secret":"\u092a\u0947\u0938\u094d\u091f\u0948\u0915 \u0938\u0940\u0915\u094d\u0930\u0947\u091f \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","phone":"\u092b\u094b\u0928","phone_number_required":"\u092b\u094b\u0928 \u0928\u0902\u092c\u0930 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","phonepe_env_required":"PhonePe \u0935\u093e\u0924\u093e\u0935\u0930\u0923 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","phonepe_merchant_id_required":"PhonePe \u0935\u094d\u092f\u093e\u092a\u093e\u0930\u0940 \u0906\u0908\u0921\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","phonepe_merchant_transaction_id_required":"PhonePe \u0935\u094d\u092f\u093e\u092a\u093e\u0930\u0940 \u0932\u0947\u0928-\u0926\u0947\u0928 \u0906\u0908\u0921\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","phonepe_merchant_user_id_required":"PhonePe \u0935\u094d\u092f\u093e\u092a\u093e\u0930\u0940 \u0909\u092a\u092f\u094b\u0917\u0915\u0930\u094d\u0924\u093e \u0906\u0908\u0921\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","phonepe_salt_index_required":"PhonePe \u0938\u0949\u0932\u094d\u091f \u0907\u0902\u0921\u0947\u0915\u094d\u0938 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","phonepe_salt_key_required":"PhonePe \u0938\u0949\u0932\u094d\u091f \u0915\u0941\u0902\u091c\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","plan":"\u092f\u094b\u091c\u0928\u093e","plan_expire_notification":"\u092f\u094b\u091c\u0928\u093e \u0938\u092e\u093e\u092a\u094d\u0924\u093f \u0938\u0942\u091a\u0928\u093e \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","please_select_user":"\u0915\u0943\u092a\u092f\u093e \u090f\u0915 \u0909\u092a\u092f\u094b\u0917\u0915\u0930\u094d\u0924\u093e \u091a\u092f\u0928 \u0915\u0930\u0947\u0902","please_wait":"\u0915\u0943\u092a\u092f\u093e \u092a\u094d\u0930\u0924\u0940\u0915\u094d\u0937\u093e \u0915\u0930\u0947\u0902...","privacy_policy":"\u0917\u094b\u092a\u0928\u0940\u092f\u0924\u093e \u0928\u0940\u0924\u093f","product":"\u0909\u0924\u094d\u092a\u093e\u0926","provide_valid_wbsite_url":"\u0915\u0943\u092a\u092f\u093e \u090f\u0915 \u092e\u093e\u0928\u094d\u092f \u092f\u0942\u0906\u0930\u090f\u0932 \u0926\u0930\u094d\u091c \u0915\u0930\u0947\u0902","purchase":"\u0916\u0930\u0940\u0926","razorpay_key":"\u0930\u0947\u091c\u0930\u092a\u0947 \u0915\u0941\u0902\u091c\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","razorpay_secret":"\u0930\u0947\u091c\u0930\u092a\u0947 \u0938\u0940\u0915\u094d\u0930\u0947\u091f \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","rejected":"\u0905\u0938\u094d\u0935\u0940\u0915\u0943\u0924","remove":"\u0939\u091f\u093e\u090f\u0901","sat":"\u0936\u0928\u093f","select_all":"\u0938\u092d\u0940 \u091a\u0941\u0928\u0947\u0902","select_email_required":"\u092e\u0947\u0932 \u092d\u0947\u091c\u0928\u0947 \u0915\u093e \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","select_hour":"\u0915\u0943\u092a\u092f\u093e \u0924\u093f\u0925\u093f \u092f\u093e \u0938\u092e\u092f \u091a\u0941\u0928\u0947\u0902","select_one_or_more":"\u090f\u0915 \u092f\u093e \u0905\u0927\u093f\u0915 \u0935\u093f\u0915\u0932\u094d\u092a \u091a\u0941\u0928\u0928\u093e \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948","select_payment_type":"\u092d\u0941\u0917\u0924\u093e\u0928 \u092a\u094d\u0930\u0915\u093e\u0930 \u091a\u0941\u0928\u0947\u0902","select_user":"\u0909\u092a\u092f\u094b\u0917\u0915\u0930\u094d\u0924\u093e \u091a\u0941\u0928\u0947\u0902","select_vcard":"\u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u091a\u0941\u0928\u0947\u0902","send_email_description":"\u0935\u093f\u0935\u0930\u0923","sep":"\u0938\u093f\u0924\u0902\u092c\u0930","short_description":"\u0938\u0902\u0915\u094d\u0937\u093f\u092a\u094d\u0924 \u0935\u093f\u0935\u0930\u0923 \u0926\u0930\u094d\u091c \u0915\u0930\u0947\u0902","skip":"\u091b\u094b\u0921\u093c\u0947\u0902","social_links_img_is_required":"\u0938\u094b\u0936\u0932 \u0932\u093f\u0902\u0915 \u0915\u0940 \u091b\u0935\u093f \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","social_links_is_required":"\u0938\u094b\u0936\u0932 \u0932\u093f\u0902\u0915 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","state":"\u0930\u093e\u091c\u094d\u092f","stripe_key":"\u0938\u094d\u091f\u094d\u0930\u093e\u0907\u092a \u0915\u0941\u0902\u091c\u0940 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","stripe_secret":"\u0938\u094d\u091f\u094d\u0930\u093e\u0907\u092a \u0938\u0940\u0915\u094d\u0930\u0947\u091f \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","subject_required":"\u0935\u093f\u0937\u092f \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","subscriptions":"\u0938\u0926\u0938\u094d\u092f\u0924\u093e\u090f\u0901","successful":"\u0938\u092b\u0932","sun":"\u0930\u0935\u093f","term_condition":"\u0936\u0930\u094d\u0924\u0947\u0902 \u0914\u0930 \u0928\u093f\u092f\u092e","testimonial":"\u092a\u094d\u0930\u0936\u0902\u0938\u093e\u092a\u0924\u094d\u0930","the_description_field_is_required":"\u0935\u093f\u0935\u0930\u0923 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","the_term_conditions":"\u0936\u0930\u094d\u0924\u0947\u0902 \u0914\u0930 \u0928\u093f\u092f\u092e \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0902\u0964","this_is_analytics_chart":"\u092f\u0939 \u0906\u092a\u0915\u093e \u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u090f\u0928\u093e\u0932\u093f\u091f\u093f\u0915\u094d\u0938 \u091a\u093e\u0930\u094d\u091f \u0939\u0948\u0964","this_month":"\u0907\u0938 \u092e\u0939\u0940\u0928\u0947","this_week":"\u0907\u0938 \u0938\u092a\u094d\u0924\u093e\u0939","thu":"\u0917\u0941\u0930\u0941","to":"\u0924\u0915","today":"\u0906\u091c","too_long":"\u092c\u0939\u0941\u0924 \u0932\u0902\u092c\u093e","too_short":"\u092c\u0939\u0941\u0924 \u091b\u094b\u091f\u093e","tue":"\u092e\u0902\u0917\u0932","unavailable":"\u0909\u092a\u0932\u092c\u094d\u0927 \u0928\u0939\u0940\u0902","upload_required":"\u092b\u093c\u093e\u0907\u0932 \u0905\u092a\u0932\u094b\u0921 \u092b\u093c\u0940\u0932\u094d\u0921 \u0906\u0935\u0936\u094d\u092f\u0915 \u0939\u0948\u0964","user":"\u0909\u092a\u092f\u094b\u0917\u0915\u0930\u094d\u0924\u093e","vcard":"\u0935\u0940\u0915\u093e\u0930\u094d\u0921","vcard_iframe":"\u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0906\u0908\u092b\u094d\u0930\u0947\u092e","vcard_name":"\u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0928\u093e\u092e","vcard_name_required":"\u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0928\u093e\u092e \u0915\u093e \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u0905\u0928\u093f\u0935\u093e\u0930\u094d\u092f \u0939\u0948","vcard_service":"\u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u0938\u0947\u0935\u093e","vcard_testimonial":"\u0935\u0940\u0915\u093e\u0930\u094d\u0921 \u092a\u094d\u0930\u0936\u0902\u0938\u093e\u092a\u0924\u094d\u0930","website_field_required":"\u0935\u0947\u092c\u0938\u093e\u0907\u091f \u0915\u093e \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u0905\u0928\u093f\u0935\u093e\u0930\u094d\u092f \u0939\u0948","wed":"\u092c\u0941\u0927","yes":"\u0939\u093e\u0901","yesterday":"\u0915\u0932"},"it.js":{"Yes_Change":"S\u00ec, Approva","add_on":"Aggiungi","address_field":"Il campo Indirizzo \u00e8 obbligatorio.","admin":"Admin","affiliation_amount_error":"L'importo dell'affiliazione non pu\u00f2 superare il 100%","agree_term":"Devi accettare i Termini e condizioni.","allowed_file_types":"Tipi di file consentiti: png, jpg, jpeg.","allowed_image":"Tipi di file consentiti: png, jpg, jpeg.","amount":"Importo","app_name_required":"Il campo Nome App \u00e8 obbligatorio","apply":"Applica","appointment":"Appuntamento","appointments":"Appuntamenti","approved":"Approvato","apr":"Apr","are_you_completed":"Sei sicuro di voler approvare questo?","are_you_sure":"Sei sicuro di voler eliminare questo","are_you_sure_dublicate_vcard":"Sei sicuro di voler duplicare questo VCard?","aug":"Ago","back_image_field_required":"Il campo dellimmagine posteriore \u00e8 obbligatorio","blog":"Blog","blog_description":"Descrizione","blog_image_required":"Il campo immagine del blog \u00e8 obbligatorio.","cancel":"Annulla","check_email":"Email gi\u00e0 esistente.","choose_one_template":"Scegli un qualsiasi template","choose_plan":"Scegli un piano","city":"Citt\u00e0","click_open_sidebar":"Fai clic su Avanti per aprire la barra laterale.","click_to_add_vcard_name":"Fai clic qui per aggiungere il nome della tua Vcard.","click_to_create_vcards":"Fai clic su Avanti per creare la tua VCard.","click_to_generate_alias":"Fai clic qui per generare il tuo alias URL.","click_to_go_dashboard":"Fai clic su Avanti per accedere alla Dashboard.","click_to_make_vcards":"Fai clic su Avanti per creare nuove VCard.","click_to_open_edit_sidebar":"Fai clic su Avanti per accedere alla barra laterale di modifica della VCard.","click_to_preview":"Fai clic qui per visualizzare l'anteprima della tua VCard.","click_to_save_vcard":"Fai clic su Avanti per salvare la tua VCard.","completed":"Completato","copied_successfully":"Link copiato con successo.","country":"Paese","coupon_code":"Codici Coupon","coupon_code_apply":"Codice coupon applicato con successo.","coupon_code_percent_validation":"Lo sconto del coupon non pu\u00f2 essere superiore al 100%.","custom":"Personalizzato","custom_link":"Collegamento Personalizzato","dec":"Dic","delete":"Elimina","deleted":"Eliminato","description":"Inserisci la descrizione del tuo VCard","description_length":"La descrizione deve contenere almeno 3 caratteri.","description_required":"Il campo descrizione \u00e8 obbligatorio.","duplicate":"Duplicato!","duplicate_vcard":"Vcard duplicato!","duplicate_vcard_create":"Duplicato di Vcard creato con successo","email":"Email","email_required":"Il campo email \u00e8 obbligatorio","embedtag":"Tag incorporato","enquiry":"Richiesta","enter_valid_email":"Inserisci un'email valida.","enter_vcard_name":"Si prega di inserire un nome Vcard","error":"Errore","faqs":"Domande frequenti","feb":"Feb","first_name_required":"Il campo Nome \u00e8 obbligatorio.","flat":"Flat","flutterwave_key":"Il campo Chiave Flutterwave \u00e8 obbligatorio.","flutterwave_secret":"Il campo Segreto Flutterwave \u00e8 obbligatorio.","fri":"VEN","from":"Da","front_image_field_required":"Il campo dellimmagine frontale \u00e8 obbligatorio","gallery":"Galleria","generate_url_alias":"Si prega di generare un alias URL","has_been_completed":"\u00e8 stato completato.","has_been_deleted":"\u00e8 stato eliminato.","here_select_vcard_template":"Qui puoi selezionare il template della tua VCard.","image_too_large":"Il tuo file \u00e8 troppo grande. La dimensione massima consentita \u00e8 1 MB.","in_progress":"In corso","inquries":"Richieste","invalid_country_code":"Prefisso internazionale non valido","invalid_email":"L'email non \u00e8 valida","invalid_number":"Numero non valido","jan":"Gen","jul":"Lug","jun":"Giu","last_30_days":"Ultimi 30 giorni","last_7_days":"Ultimi 7 giorni","last_name_required":"Il campo Cognome \u00e8 obbligatorio.","last_week":"Settimana scorsa","loading":"Caricamento...","location_field_required":"Il campo posizione \u00e8 obbligatorio","logo_field_required":"Il campo del logo del biglietto da visita \u00e8 obbligatorio","logo_image_error":"Le dimensioni dellimmagine devono essere 150x150 pixel o meno.","manual_payment_guide":"Guida al pagamento manuale","mar":"Mar","may":"Mag","mon":"LUN","month":"Mese","multi_templates":"Sono richiesti multipli template","next":"Avanti","nfc_card":"Carta NFC","no":"No","nov":"Nov","occupation_field_required":"Il campo occupazione \u00e8 obbligatorio","oct":"Ott","ok":"Ok","onesignal_app_id":"Il campo ID App Onesignal \u00e8 obbligatorio.","onesignal_rest_api_key":"Il campo Chiave API REST Onesignal \u00e8 obbligatorio.","password_character":"La password deve contenere almeno 8 caratteri.","password_must_match":"La password e la conferma della password devono corrispondere.","passwords":"Il campo Password \u00e8 obbligatorio.","payment_not_complete":"Pagamento non completato","paypal_key":"Il campo ID Cliente Paypal \u00e8 obbligatorio.","paypal_mode":"Il campo Modalit\u00e0 Paypal \u00e8 obbligatorio.","paypal_secret":"Il campo Segreto Paypal \u00e8 obbligatorio.","paystack_key":"Il campo Chiave Paystack \u00e8 obbligatorio.","paystack_secret":"Il campo Segreto Paystack \u00e8 obbligatorio.","phone":"Telefono","phone_number_required":"Il campo Numero di telefono \u00e8 obbligatorio.","phonepe_env_required":"Il campo Ambiente di Phonepe \u00e8 obbligatorio.","phonepe_merchant_id_required":"Il campo ID commerciante di Phonepe \u00e8 obbligatorio.","phonepe_merchant_transaction_id_required":"Il campo ID transazione commerciante di Phonepe \u00e8 obbligatorio.","phonepe_merchant_user_id_required":"Il campo ID utente commerciante di Phonepe \u00e8 obbligatorio.","phonepe_salt_index_required":"Il campo Indice di Salt di Phonepe \u00e8 obbligatorio.","phonepe_salt_key_required":"Il campo Chiave di Salt di Phonepe \u00e8 obbligatorio.","plan":"Piano","plan_expire_notification":"Il campo Notifica scadenza piano \u00e8 obbligatorio.","please_select_user":"Per favore, seleziona un utente","please_wait":"Attendere prego...","privacy_policy":"Informativa sulla privacy","product":"Prodotto","provide_valid_wbsite_url":"Inserisci un URL valido","purchase":"Acquisto","razorpay_key":"Il campo Chiave Razorpay \u00e8 obbligatorio.","razorpay_secret":"Il campo Segreto Razorpay \u00e8 obbligatorio.","rejected":"Rifiutato","remove":"Rimuovi","sat":"SAB","select_all":"Seleziona tutto","select_email_required":"Il campo Invia email \u00e8 obbligatorio.","select_hour":"Seleziona Data o Ora","select_one_or_more":"Seleziona uno o pi\u00f9 Elementi richiesti","select_payment_type":"Seleziona Tipo di Pagamento","select_user":"Seleziona utente","select_vcard":"Seleziona VCard","send_email_description":"Descrizione","sep":"Set","short_description":"Inserisci una breve descrizione","skip":"Salta","social_links_img_is_required":"\u00c8 necessaria un'immagine dei link social.","social_links_is_required":"I link social sono obbligatori.","state":"Stato","stripe_key":"Il campo chiave di Stripe \u00e8 obbligatorio.","stripe_secret":"Il campo Segreto Stripe \u00e8 obbligatorio.","subject_required":"Il campo Oggetto \u00e8 obbligatorio.","subscriptions":"Abbonamenti","successful":"Successo","sun":"DOM","term_condition":"Termini e condizioni","testimonial":"Testimoniale","the_term_conditions":"I Termini e condizioni sono obbligatori.","this_is_analytics_chart":"Questo \u00e8 il tuo grafico di analisi VCard.","this_month":"Questo mese","this_week":"Questa settimana","thu":"GIO","to":"A","today":"Oggi","too_long":"Troppo lungo","too_short":"Troppo corto","tue":"MAR","unavailable":"Non disponibile","upload_required":"Il campo di caricamento del file \u00e8 obbligatorio.","user":"Utente","vcard":"VCard","vcard_iframe":"Iframe di VCard","vcard_name":"Nome VCard","vcard_name_required":"Il campo nome del biglietto da visita \u00e8 obbligatorio","vcard_service":"Servizio VCard","vcard_testimonial":"Testimonianza VCard","website_field_required":"Il campo sito web \u00e8 obbligatorio","wed":"MER","yes":"S\u00ec","yesterday":"Ieri"},"pt.js":{"Yes_Change":"Sim, Aprovar","add_on":"Adicionar","address_field":"O campo de Endere\u00e7o \u00e9 obrigat\u00f3rio.","admin":"Admin","affiliation_amount_error":"O valor da filia\u00e7\u00e3o n\u00e3o pode exceder 100%","agree_term":"Voc\u00ea deve concordar com os Termos e Condi\u00e7\u00f5es.","allowed_file_types":"Tipos de arquivo permitidos: png, jpg, jpeg.","allowed_image":"Tipos de arquivo permitidos: png, jpg, jpeg.","amount":"Quantidade","app_name_required":"O campo Nome do Aplicativo \u00e9 obrigat\u00f3rio","apply":"Aplicar","appointment":"Compromisso","appointments":"Compromissos","approved":"Aprovado","apr":"Abr","are_you_completed":"Voc\u00ea tem certeza de que deseja aprovar isso?","are_you_sure":"Tem certeza de que deseja excluir isso","are_you_sure_dublicate_vcard":"Tem certeza de que deseja criar uma duplicata deste VCard?","aug":"Ago","back_image_field_required":"Campo da imagem de fundo \u00e9 obrigat\u00f3rio","blog":"Blog","blog_description":"Descri\u00e7\u00e3o","blog_image_required":"O campo de imagem do blog \u00e9 obrigat\u00f3rio.","cancel":"Cancelar","check_email":"E-mail j\u00e1 existe.","choose_one_template":"Escolha qualquer modelo","choose_plan":"Escolha o Plano","city":"Cidade","click_open_sidebar":"Clique em Pr\u00f3ximo para abrir a barra lateral.","click_to_add_vcard_name":"Clique aqui para adicionar o nome do seu cart\u00f5es.","click_to_create_vcards":"Clique em Pr\u00f3ximo para criar seu cart\u00f5es.","click_to_generate_alias":"Clique aqui para gerar seu alias de URL.","click_to_go_dashboard":"Clique em Pr\u00f3ximo para prosseguir para o painel.","click_to_make_vcards":"Clique em Pr\u00f3ximo para criar novos cart\u00f5es.","click_to_open_edit_sidebar":"Clique em Pr\u00f3ximo para acessar a barra lateral de edi\u00e7\u00e3o do cart\u00f5es.","click_to_preview":"Clique aqui para visualizar seu cart\u00f5es.","click_to_save_vcard":"Clique em Pr\u00f3ximo para salvar seu cart\u00f5es.","completed":"Conclu\u00eddo","copied_successfully":"Link copiado com sucesso.","country":"Pa\u00eds","coupon_code":"C\u00f3digos de Cupom","coupon_code_apply":"C\u00f3digo do cupom aplicado com sucesso.","coupon_code_percent_validation":"O desconto do cupom n\u00e3o deve ser superior a 100%.","custom":"Personalizado","custom_link":"Link Personalizado","dec":"Dez","delete":"Excluir","deleted":"Exclu\u00eddo","description":"Insira uma descri\u00e7\u00e3o do seu cart\u00e3o","description_length":"A descri\u00e7\u00e3o deve ter pelo menos 3 caracteres.","description_required":"O campo Descri\u00e7\u00e3o \u00e9 obrigat\u00f3rio.","duplicate":"Duplicar!","duplicate_vcard":"cart\u00f5es Duplicado!","duplicate_vcard_create":"cart\u00f5es duplicado criado com sucesso","email":"E-mail","email_required":"O campo e-mail \u00e9 obrigat\u00f3rio","embedtag":"Incorporar etiqueta","enquiry":"Consulta","enter_valid_email":"Por favor, insira um e-mail v\u00e1lido.","enter_vcard_name":"Por favor insira um nome cart\u00f5es","error":"Erro","faqs":"FAQs","feb":"Fev","first_name_required":"O campo Nome \u00e9 obrigat\u00f3rio.","flat":"Fixo","flutterwave_key":"O campo de chave Flutterwave \u00e9 obrigat\u00f3rio.","flutterwave_secret":"O campo de segredo Flutterwave \u00e9 obrigat\u00f3rio.","fri":"SEX","from":"De","front_image_field_required":"Campo da imagem frontal \u00e9 obrigat\u00f3rio","gallery":"Galeria","generate_url_alias":"Gere um alias de URL","has_been_completed":"foi conclu\u00eddo.","has_been_deleted":"foi exclu\u00eddo.","here_select_vcard_template":"Aqui voc\u00ea pode selecionar seu modelo cart\u00f5es.","image_too_large":"Seu arquivo \u00e9 muito grande. O tamanho m\u00e1ximo permitido \u00e9 1MB.","in_progress":"Em andamento","inquries":"Investiga\u00e7\u00e3o","invalid_country_code":"C\u00f3digo de pa\u00eds inv\u00e1lido","invalid_email":"O e-mail \u00e9 inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","jan":"Jan","jul":"Jul","jun":"Jun","last_30_days":"\u00daltimos 30 dias","last_7_days":"\u00daltimos 7 dias","last_name_required":"O campo Sobrenome \u00e9 obrigat\u00f3rio.","last_week":"Semana Passada","loading":"Carregando...","location_field_required":"Campo de localiza\u00e7\u00e3o \u00e9 obrigat\u00f3rio","logo_field_required":"Campo do logotipo do cart\u00e3o \u00e9 obrigat\u00f3rio","logo_image_error":"As dimens\u00f5es da imagem devem ser 150x150 pixels ou menos.","manual_payment_guide":"Guia de Pagamento Manual","mar":"Mar","may":"Mai","mon":"SEG","month":"M\u00eas","multi_templates":"M\u00faltiplos modelos s\u00e3o necess\u00e1rios","next":"Pr\u00f3xima","nfc_card":"Cart\u00e3o NFC","no":"N\u00e3o","nov":"Nov","occupation_field_required":"Campo de ocupa\u00e7\u00e3o \u00e9 obrigat\u00f3rio","oct":"Out","ok":"Ok","onesignal_app_id":"O campo de ID do aplicativo do OneSignal \u00e9 obrigat\u00f3rio.","onesignal_rest_api_key":"O campo da chave de API REST do OneSignal \u00e9 obrigat\u00f3rio.","password_character":"A senha deve ter pelo menos 8 caracteres.","password_must_match":"A senha e a confirma\u00e7\u00e3o da senha devem ser iguais.","passwords":"O campo Senhas \u00e9 obrigat\u00f3rio.","payment_not_complete":"Pagamento n\u00e3o conclu\u00eddo","paypal_key":"O campo ID do cliente Paypal \u00e9 obrigat\u00f3rio.","paypal_mode":"O campo Modo do Paypal \u00e9 obrigat\u00f3rio.","paypal_secret":"O campo Segredo do Paypal \u00e9 obrigat\u00f3rio.","paystack_key":"O campo de chave Paystack \u00e9 obrigat\u00f3rio.","paystack_secret":"O campo de segredo Paystack \u00e9 obrigat\u00f3rio.","phone":"Telefone","phone_number_required":"O campo N\u00famero de Telefone \u00e9 obrigat\u00f3rio.","phonepe_env_required":"O campo Phonepe Env \u00e9 obrigat\u00f3rio.","phonepe_merchant_id_required":"O campo ID do comerciante do Phonepe \u00e9 obrigat\u00f3rio.","phonepe_merchant_transaction_id_required":"O campo ID de transa\u00e7\u00e3o do comerciante do Phonepe \u00e9 obrigat\u00f3rio.","phonepe_merchant_user_id_required":"O campo ID do usu\u00e1rio do comerciante do Phonepe \u00e9 obrigat\u00f3rio.","phonepe_salt_index_required":"O campo \u00cdndice de Sal do Phonepe \u00e9 obrigat\u00f3rio.","phonepe_salt_key_required":"O campo Chave de Sal do Phonepe \u00e9 obrigat\u00f3rio.","plan":"Plano","plan_expire_notification":"O campo de Notifica\u00e7\u00e3o de Expira\u00e7\u00e3o do Plano \u00e9 obrigat\u00f3rio.","please_select_user":"Por favor, selecione um usu\u00e1rio","please_wait":"Por favor, aguarde...","privacy_policy":"Pol\u00edtica de Privacidade","product":"Produto","provide_valid_wbsite_url":"Insira uma URL v\u00e1lida","purchase":"Compra","razorpay_key":"O campo-chave Rozorpay \u00e9 obrigat\u00f3rio.","razorpay_secret":"O campo Rozorpay Secret \u00e9 obrigat\u00f3rio.","rejected":"Rejeitado","remove":"Remover","sat":"S\u00c1B","select_all":"Selecionar tudo","select_email_required":"O campo Enviar e-mail \u00e9 obrigat\u00f3rio.","select_hour":"Por favor, selecione Data ou Hora","select_one_or_more":"Selecione uma ou mais caracter\u00edsticas s\u00e3o necess\u00e1rias","select_payment_type":"Selecione o tipo de pagamento","select_user":"Selecionar usu\u00e1rio","select_vcard":"Selecione Vcard","send_email_description":"Descri\u00e7\u00e3o","sep":"Set","short_description":"Digite uma descri\u00e7\u00e3o curta","skip":"Pular","social_links_img_is_required":"A imagem dos links sociais \u00e9 obrigat\u00f3ria.","social_links_is_required":"Links sociais s\u00e3o obrigat\u00f3rios.","state":"Estado","stripe_key":"O campo de chave Stripe \u00e9 obrigat\u00f3rio.","stripe_secret":"O campo Segredo do Stripe \u00e9 obrigat\u00f3rio.","subject_required":"O campo assunto \u00e9 obrigat\u00f3rio.","subscriptions":"Assinaturas","successful":"Bem-sucedido","sun":"DOM","term_condition":"Termos e Condi\u00e7\u00f5es","testimonial":"Depoimento","the_term_conditions":"Os Termos e Condi\u00e7\u00f5es s\u00e3o obrigat\u00f3rios.","this_is_analytics_chart":"Este \u00e9 o seu gr\u00e1fico anal\u00edtico do cart\u00f5es.","this_month":"Este m\u00eas","this_week":"Esta Semana","thu":"QUI","to":"Para","today":"Hoje","too_long":"Muito longo","too_short":"Muito curto","tue":"TER","unavailable":"Indispon\u00edvel","upload_required":"O campo de upload de arquivo \u00e9 obrigat\u00f3rio.","user":"Usu\u00e1rio","vcard":"VCard","vcard_iframe":"Iframe do VCard","vcard_name":"Nome do VCard","vcard_name_required":"Campo de nome do cart\u00e3o \u00e9 obrigat\u00f3rio","vcard_service":"Servi\u00e7o VCard","vcard_testimonial":"Depoimento VCard","website_field_required":"Campo do site \u00e9 obrigat\u00f3rio","wed":"QUA","yes":"Sim","yesterday":"Ontem"},"ru.js":{"Yes_Change":"\u0414\u0430, \u041e\u0434\u043e\u0431\u0440\u0438\u0442\u044c","add_on":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c","address_field":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0435 \"\u0410\u0434\u0440\u0435\u0441\".","admin":"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440","affiliation_amount_error":"\u0421\u0443\u043c\u043c\u0430 \u0430\u0444\u0444\u0438\u043b\u0438\u0430\u0446\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c 100%","agree_term":"\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0433\u043b\u0430\u0441\u0438\u0442\u044c\u0441\u044f \u0441 \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u043c\u0438.","allowed_file_types":"\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg.","allowed_image":"\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg.","amount":"\u0421\u0443\u043c\u043c\u0430","app_name_required":"\u041f\u043e\u043b\u0435 \"\u0418\u043c\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f","apply":"\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c","appointment":"\u0417\u0430\u043f\u0438\u0441\u044c","appointments":"\u0417\u0430\u043f\u0438\u0441\u0438","approved":"\u041e\u0434\u043e\u0431\u0440\u0435\u043d\u043e","apr":"\u0410\u043f\u0440","are_you_completed":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0434\u043e\u0431\u0440\u0438\u0442\u044c \u044d\u0442\u043e?","are_you_sure":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e","are_you_sure_dublicate_vcard":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u044d\u0442\u043e\u0439 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438?","aug":"\u0410\u0432\u0433","back_image_field_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0434\u043d\u0435\u0433\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","blog":"\u0411\u043b\u043e\u0433","blog_description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","blog_image_required":"\u041f\u043e\u043b\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u0433\u0430 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","check_email":"\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.","choose_one_template":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u044e\u0431\u043e\u0439 \u0448\u0430\u0431\u043b\u043e\u043d","choose_plan":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d","city":"\u0413\u043e\u0440\u043e\u0434","click_open_sidebar":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u00ab\u0414\u0430\u043b\u0435\u0435\u00bb, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0431\u043e\u043a\u043e\u0432\u0443\u044e \u043f\u0430\u043d\u0435\u043b\u044c.","click_to_create_vcards":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u00ab\u0414\u0430\u043b\u0435\u0435\u00bb, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0432\u043e\u044e \u0432\u0438\u0437\u0438\u0442\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0443.","click_to_generate_alias":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0437\u0434\u0435\u0441\u044c, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0441\u0435\u0432\u0434\u043e\u043d\u0438\u043c URL-\u0430\u0434\u0440\u0435\u0441\u0430.","click_to_go_dashboard":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u00ab\u0414\u0430\u043b\u0435\u0435\u00bb, \u0447\u0442\u043e\u0431\u044b \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u043d\u0430 \u043f\u0430\u043d\u0435\u043b\u044c \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432.","click_to_make_vcards":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u00ab\u0414\u0430\u043b\u0435\u0435\u00bb, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0435 VCards.","click_to_open_edit_sidebar":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u00ab\u0414\u0430\u043b\u0435\u0435\u00bb, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0431\u043e\u043a\u043e\u0432\u043e\u0439 \u043f\u0430\u043d\u0435\u043b\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f VCard.","click_to_preview":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0437\u0434\u0435\u0441\u044c, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432\u0430\u0448\u0443 \u0432\u0438\u0437\u0438\u0442\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0443.","click_to_save_vcard":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u00ab\u0414\u0430\u043b\u0435\u0435\u00bb, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u0443 VCard.","completed":"\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e","copied_successfully":"\u0421\u0441\u044b\u043b\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0430.","country":"\u0421\u0442\u0440\u0430\u043d\u0430","coupon_code":"\u041f\u0440\u043e\u043c\u043e\u043a\u043e\u0434\u044b","coupon_code_apply":"\u041f\u0440\u043e\u043c\u043e\u043a\u043e\u0434 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d.","coupon_code_percent_validation":"\u0421\u043a\u0438\u0434\u043a\u0430 \u043f\u043e \u043a\u0443\u043f\u043e\u043d\u0443 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u0435\u0435 100%.","custom":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439","custom_link":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u0421\u0441\u044b\u043b\u043a\u0430","dec":"\u0414\u0435\u043a","delete":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e","description":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0430\u0448\u0435\u0439 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438","description_length":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043a\u0430\u043a \u043c\u0438\u043d\u0438\u043c\u0443\u043c 3 \u0441\u0438\u043c\u0432\u043e\u043b\u0430.","description_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","duplicate":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442!","duplicate_vcard":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u0432","duplicate_vcard_create":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430","email_required":"\u041f\u043e\u043b\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","embedtag":"\u0412\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0442\u0435\u0433","enquiry":"\u0417\u0430\u043f\u0440\u043e\u0441","enter_valid_email":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b.","enter_vcard_name":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f Vcard","error":"\u041e\u0448\u0438\u0431\u043a\u0430","faqs":"\u0427\u0430\u0441\u0442\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b","feb":"\u0424\u0435\u0432","first_name_required":"\u041f\u043e\u043b\u0435 \"\u0418\u043c\u044f\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","flat":"\u041f\u043b\u043e\u0441\u043a\u0438\u0439","flutterwave_key":"\u041f\u043e\u043b\u0435 \u043a\u043b\u044e\u0447\u0430 Flutterwave \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","flutterwave_secret":"\u041f\u043e\u043b\u0435 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 Flutterwave \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","fri":"\u041f\u0422","from":"\u041e\u0442","front_image_field_required":"\u041f\u043e\u043b\u0435 \u043f\u0435\u0440\u0435\u0434\u043d\u0435\u0433\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","gallery":"\u0413\u0430\u043b\u0435\u0440\u0435\u044f","generate_url_alias":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0441\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u043f\u0441\u0435\u0432\u0434\u043e\u043d\u0438\u043c URL-\u0430\u0434\u0440\u0435\u0441\u0430","has_been_completed":"\u0431\u044b\u043b\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430.","has_been_deleted":"\u0431\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e.","here_select_vcard_template":"\u0417\u0434\u0435\u0441\u044c \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d VCard.","image_too_large":"\u0412\u0430\u0448 \u0444\u0430\u0439\u043b \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a. \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u2014 1 \u041c\u0411.","in_progress":"\u0412 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435","inquries":"\u0420\u0430\u0441\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435","invalid_country_code":"\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u0430","invalid_number":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","jan":"\u042f\u043d\u0432","jul":"\u0418\u044e\u043b","jun":"\u0418\u044e\u043d","last_30_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439","last_7_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 7 \u0434\u043d\u0435\u0439","last_name_required":"\u041f\u043e\u043b\u0435 \"\u0424\u0430\u043c\u0438\u043b\u0438\u044f\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","last_week":"\u041d\u0430 \u043f\u0440\u043e\u0448\u043b\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","loading":"\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...","location_field_required":"\u041f\u043e\u043b\u0435 \u043c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","logo_field_required":"\u041f\u043e\u043b\u0435 \u043b\u043e\u0433\u043e\u0442\u0438\u043f\u0430 \u043a\u0430\u0440\u0442\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","logo_image_error":"\u0420\u0430\u0437\u043c\u0435\u0440\u044b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c 150x150 \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439 \u0438\u043b\u0438 \u043c\u0435\u043d\u044c\u0448\u0435.","manual_payment_guide":"\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u043f\u043e \u0440\u0443\u0447\u043d\u043e\u0439 \u043e\u043f\u043b\u0430\u0442\u0435","mar":"\u041c\u0430\u0440","may":"\u041c\u0430\u0439","mon":"\u041f\u041d","month":"\u041c\u0435\u0441\u044f\u0446","multi_templates":"\u0422\u0440\u0435\u0431\u0443\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432","next":"\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439","nfc_card":"NFC \u041a\u0430\u0440\u0442\u0430","no":"\u041d\u0435\u0442","nov":"\u041d\u043e\u044f","occupation_field_required":"\u041f\u043e\u043b\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","oct":"\u041e\u043a\u0442","ok":"\u041e\u043a","onesignal_app_id":"\u041f\u043e\u043b\u0435 ID \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f OneSignal \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","onesignal_rest_api_key":"\u041f\u043e\u043b\u0435 \u043a\u043b\u044e\u0447\u0430 REST API OneSignal \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","password_character":"\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 8 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.","password_must_match":"\u041f\u0430\u0440\u043e\u043b\u044c \u0438 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c.","passwords":"\u041f\u043e\u043b\u0435 \"\u041f\u0430\u0440\u043e\u043b\u0438\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","payment_not_complete":"\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430","paypal_key":"\u041f\u043e\u043b\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 PayPal \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","paypal_mode":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0440\u0435\u0436\u0438\u043c PayPal.","paypal_secret":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 PayPal.","paystack_key":"\u041f\u043e\u043b\u0435 \u043a\u043b\u044e\u0447\u0430 Paystack \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","paystack_secret":"\u041f\u043e\u043b\u0435 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 Paystack \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","phone":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d","phone_number_required":"\u041f\u043e\u043b\u0435 \"\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430\" \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","phonepe_env_required":"\u041f\u043e\u043b\u0435 Phonepe Env \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","phonepe_merchant_id_required":"\u041f\u043e\u043b\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0442\u043e\u0440\u0433\u043e\u0432\u0446\u0430 Phonepe \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","phonepe_merchant_transaction_id_required":"\u041f\u043e\u043b\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0442\u043e\u0440\u0433\u043e\u0432\u0446\u0430 Phonepe \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","phonepe_merchant_user_id_required":"\u041f\u043e\u043b\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0442\u043e\u0440\u0433\u043e\u0432\u0446\u0430 Phonepe \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","phonepe_salt_index_required":"\u041f\u043e\u043b\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0441\u043e\u043b\u0438 Phonepe \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","phonepe_salt_key_required":"\u041f\u043e\u043b\u0435 \u043a\u043b\u044e\u0447\u0430 \u0441\u043e\u043b\u0438 Phonepe \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","plan":"\u041f\u043b\u0430\u043d","plan_expire_notification":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0438 \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043b\u0430\u043d\u0430.","please_select_user":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","please_wait":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435...","privacy_policy":"\u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","product":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442","provide_valid_wbsite_url":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL","purchase":"\u041f\u043e\u043a\u0443\u043f\u043a\u0430","razorpay_key":"\u041a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u043f\u043e\u043b\u0435 Rozorpay \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","razorpay_secret":"\u041f\u043e\u043b\u0435 Rozorpay Secret \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","rejected":"\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u043e","remove":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","sat":"\u0421\u0411","select_all":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435","select_email_required":"\u041f\u043e\u043b\u0435 \u00ab\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0447\u0442\u0443\u00bb \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","select_hour":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0438\u043b\u0438 \u0447\u0430\u0441","select_one_or_more":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0444\u0443\u043d\u043a\u0446\u0438\u0439","select_payment_type":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430","select_user":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","select_vcard":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0438\u0437\u0438\u0442\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0443","send_email_description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","sep":"\u0421\u0435\u043d","short_description":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","skip":"\u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0442\u044c","social_links_img_is_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0441\u044b\u043b\u043e\u043a.","social_links_is_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438.","state":"\u0428\u0442\u0430\u0442","stripe_key":"\u041f\u043e\u043b\u0435 \u043a\u043b\u044e\u0447\u0430 Stripe \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","stripe_secret":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 Stripe.","subject_required":"\u041f\u043e\u043b\u0435 \u0422\u0435\u043c\u0430 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","subscriptions":"\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438","successful":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e","sun":"\u0412\u0421","term_condition":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f","testimonial":"\u041e\u0442\u0437\u044b\u0432","the_term_conditions":"\u0422\u0440\u0435\u0431\u0443\u044e\u0442\u0441\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f.","this_is_analytics_chart":"\u042d\u0442\u043e \u0432\u0430\u0448\u0430 \u0430\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0434\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u0430 VCard.","this_month":"\u042d\u0442\u043e\u0442 \u043c\u0435\u0441\u044f\u0446","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","thu":"\u0427\u0422","to":"\u0414\u043e","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043b\u0438\u043d\u043d\u043e\u0435","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435","tue":"\u0412\u0422","unavailable":"\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e","upload_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430.","user":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c","vcard":"\u0412\u0438\u0437\u0438\u0442\u043a\u0430","vcard_iframe":"Iframe VCard","vcard_name":"\u0418\u043c\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438","vcard_name_required":"\u041f\u043e\u043b\u0435 \u0438\u043c\u0435\u043d\u0438 \u0432\u0438\u0437\u0438\u0442\u043a\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","vcard_service":"\u0421\u0435\u0440\u0432\u0438\u0441 VCard","vcard_testimonial":"\u041e\u0442\u0437\u044b\u0432 VCard","website_field_required":"\u041f\u043e\u043b\u0435 \u0432\u0435\u0431-\u0441\u0430\u0439\u0442\u0430 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","wed":"\u0421\u0420","yes":"\u0414\u0430","yesterday":"\u0412\u0447\u0435\u0440\u0430"},"tr.js":{"Yes_Change":"Evet, Onayla","add_on":"Ayriyeten","address_field":"Adres Alan\u0131 alan\u0131 gereklidir.","admin":"Y\u00f6netici","affiliation_amount_error":"Ba\u011fl\u0131l\u0131k tutar\u0131 100%'den fazla olamaz","agree_term":"\u015eartlar ve ko\u015fullar\u0131 kabul etmelisiniz.","allowed_file_types":"\u0130zin verilen dosya t\u00fcrleri: png, jpg, jpeg.","allowed_image":"\u0130zin verilen dosya t\u00fcrleri: png, jpg, jpeg.","amount":"Tutar","app_name_required":"Uygulama Ad\u0131 alan\u0131 gereklidir","apply":"Uygula","appointment":"Randevu","appointments":"Randevular","approved":"Onayland\u0131","apr":"Nis","are_you_completed":"Emin misiniz, bunu onaylamak istiyor musunuz?","are_you_sure":"Bunu silmek istedi\u011finizden emin misiniz","are_you_sure_dublicate_vcard":"Bu VCard'\u0131 \u00e7o\u011faltmak istedi\u011finizden emin misiniz?","aug":"A\u011fu","back_image_field_required":"Arka resim alan\u0131 gereklidir","blog":"Blog","blog_description":"Tan\u0131m","blog_image_required":"Blog g\u00f6rseli alan\u0131 zorunludur.","cancel":"\u0130ptal","check_email":"Bu e-posta zaten var.","choose_one_template":"Herhangi bir \u015fablonu se\u00e7in","choose_plan":"Plan Se\u00e7","city":"\u015eehir","click_open_sidebar":"Kenar \u00c7ubu\u011funu A\u00e7mak i\u00e7in \u0130leri'ye t\u0131klay\u0131n.","click_to_create_vcards":"VCard'\u0131n\u0131z\u0131 Olu\u015fturmak i\u00e7in \u0130leri'ye t\u0131klay\u0131n.","click_to_generate_alias":"URL Takma Ad\u0131n\u0131z\u0131 Olu\u015fturmak i\u00e7in Buraya T\u0131klay\u0131n.","click_to_go_dashboard":"Kontrol Paneline Devam etmek i\u00e7in \u0130leri'ye t\u0131klay\u0131n.","click_to_make_vcards":"Yeni VCard'lar Olu\u015fturmak i\u00e7in \u0130leri'ye t\u0131klay\u0131n.","click_to_open_edit_sidebar":"VCard D\u00fczenleme Kenar \u00c7ubu\u011funa Eri\u015fmek \u0130\u00e7in \u0130leri'ye t\u0131klay\u0131n.","click_to_preview":"VCard'\u0131n\u0131z\u0131 \u00d6nizlemek \u0130\u00e7in Buraya T\u0131klay\u0131n.","click_to_save_vcard":"VCard'\u0131n\u0131z\u0131 Kaydetmek i\u00e7in \u0130leri'ye t\u0131klay\u0131n.","completed":"Tamamland\u0131","copied_successfully":"Ba\u011flant\u0131 ba\u015far\u0131yla kopyaland\u0131.","country":"\u00dclke","coupon_code":"Kupon Kodlar\u0131","coupon_code_apply":"Kupon Kodu ba\u015far\u0131yla uyguland\u0131.","coupon_code_percent_validation":"Kupon indirimi %100'den fazla olmamal\u0131d\u0131r.","custom":"\u00d6zel","custom_link":"\u00d6zel Ba\u011flant\u0131","dec":"Ara","delete":"Sil","deleted":"Silindi","description":"VCard'\u0131n\u0131z\u0131n A\u00e7\u0131klamas\u0131n\u0131 Girin","description_length":"A\u00e7\u0131klama en az 3 karakter olmal\u0131d\u0131r.","description_required":"A\u00e7\u0131klama alan\u0131 zorunludur.","duplicate":"\u00c7o\u011falt\u0131ld\u0131 !","duplicate_vcard":"\u00c7o\u011falt\u0131lan Vcard !","duplicate_vcard_create":"\u00c7o\u011falt\u0131lan Vcard ba\u015far\u0131yla olu\u015fturuldu","email":"E-posta","email_required":"E-posta alan\u0131 gereklidir","embedtag":"Etiketi yerle\u015ftir","enquiry":"Sorgu","enter_valid_email":"L\u00fctfen ge\u00e7erli bir e-posta adresi girin.","enter_vcard_name":"L\u00fctfen bir Vcard Ad\u0131 girin","error":"Hata","faqs":"SSS","feb":"\u015eub","first_name_required":"Ad alan\u0131 gereklidir.","flat":"D\u00fcz","flutterwave_key":"Flutterwave anahtar alan\u0131 gereklidir.","flutterwave_secret":"Flutterwave Gizli alan\u0131 gereklidir.","fri":"CUM","from":"Kimden","front_image_field_required":"\u00d6n resim alan\u0131 gereklidir","gallery":"Galeri","generate_url_alias":"L\u00fctfen bir URL Takma Ad\u0131 Olu\u015fturun","has_been_completed":"tamamland\u0131.","has_been_deleted":"silindi.","here_select_vcard_template":"Burada VCard \u015eablonunuzu Se\u00e7ebilirsiniz.","image_too_large":"Dosyan\u0131z \u00e7ok b\u00fcy\u00fck. \u0130zin verilen maksimum boyut 1 MB't\u0131r.","in_progress":"Devam ediyor","inquries":"Sorgu","invalid_country_code":"Ge\u00e7ersiz \u00fclke kodu","invalid_email":"E-posta ge\u00e7ersiz","invalid_number":"Ge\u00e7ersiz Numara","jan":"Oca","jul":"Tem","jun":"Haz","last_30_days":"Son 30 G\u00fcn","last_7_days":"Son 7 G\u00fcn","last_name_required":"Soyad\u0131 alan\u0131 gereklidir.","last_week":"Ge\u00e7en Hafta","loading":"Y\u00fckleniyor...","location_field_required":"Konum alan\u0131 gereklidir","logo_field_required":"Kart logosu alan\u0131 gereklidir","logo_image_error":"G\u00f6r\u00fcnt\u00fc boyutlar\u0131 150x150 piksel veya daha k\u00fc\u00e7\u00fck olmal\u0131d\u0131r.","manual_payment_guide":"Manuel \u00d6deme Rehberi","mar":"Mar","may":"May","mon":"PZT","month":"Ay","multi_templates":"\u00c7oklu \u015fablonlar gereklidir","next":"Sonraki","nfc_card":"NFC Kart\u0131","no":"Hay\u0131r","nov":"Kas","occupation_field_required":"Meslek alan\u0131 gereklidir","oct":"Eki","ok":"Tamam","onesignal_app_id":"OneSignal Uygulama Kimli\u011fi alan\u0131 gereklidir.","onesignal_rest_api_key":"OneSignal REST API Anahtar\u0131 alan\u0131 gereklidir.","password_character":"\u015eifre en az 8 karakter olmal\u0131d\u0131r.","password_must_match":"\u015eifre ve \u015fifre onay\u0131 e\u015fle\u015fmelidir.","passwords":"\u015eifreler alan\u0131 gereklidir.","payment_not_complete":"\u00d6deme Tamamlanmad\u0131","paypal_key":"Paypal M\u00fc\u015fteri Kimli\u011fi alan\u0131 zorunludur.","paypal_mode":"Paypal modu alan\u0131 gereklidir.","paypal_secret":"Paypal gizli alan\u0131 gereklidir.","paystack_key":"Paystack anahtar alan\u0131 gereklidir.","paystack_secret":"Paystack Gizli alan\u0131 gereklidir.","phone":"Telefon","phone_number_required":"Telefon Numaras\u0131 alan\u0131 gereklidir.","phonepe_env_required":"Phonepe Env alan\u0131 zorunlu.","phonepe_merchant_id_required":"Phonepe t\u00fcccar kimlik alan\u0131 zorunlu.","phonepe_merchant_transaction_id_required":"Phonepe t\u00fcccar i\u015flem kimlik alan\u0131 zorunlu.","phonepe_merchant_user_id_required":"Phonepe t\u00fcccar kullan\u0131c\u0131 kimlik alan\u0131 zorunlu.","phonepe_salt_index_required":"Phonepe Salt Index alan\u0131 zorunlu.","phonepe_salt_key_required":"Phonepe Salt Key alan\u0131 zorunlu.","plan":"Plan","plan_expire_notification":"Plan Son Tarihi Bildirimi alan\u0131 gereklidir.","please_select_user":"L\u00fctfen bir kullan\u0131c\u0131 se\u00e7in","please_wait":"L\u00fctfen bekleyin...","privacy_policy":"Gizlilik Politikas\u0131","product":"\u00dcr\u00fcn","provide_valid_wbsite_url":"Ge\u00e7erli bir URL girin","purchase":"Sat\u0131n Alma","razorpay_key":"Rozorpay anahtar alan\u0131 gereklidir.","razorpay_secret":"Rozorpay Gizli alan\u0131 zorunludur.","rejected":"Reddedildi","remove":"Kald\u0131r","sat":"CMT","select_all":"T\u00fcm\u00fcn\u00fc Se\u00e7","select_email_required":"Posta G\u00f6nder alan\u0131 zorunludur.","select_hour":"L\u00fctfen Tarih veya Saat Se\u00e7in","select_one_or_more":"Bir veya daha fazla \u00f6zellik se\u00e7mek zorunludur","select_payment_type":"\u00d6deme T\u00fcr\u00fcn\u00fc Se\u00e7in","select_user":"Kullan\u0131c\u0131 se\u00e7","select_vcard":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0438\u0437\u0438\u0442\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0443","send_email_description":"A\u00e7\u0131klama","sep":"Eyl","short_description":"K\u0131sa A\u00e7\u0131klama Girin","skip":"Atlamak","social_links_img_is_required":"Sosyal ba\u011flant\u0131lar \u0130mgesi gereklidir.","social_links_is_required":"Sosyal ba\u011flant\u0131lar gereklidir.","state":"Eyalet","stripe_key":"Stripe anahtar alan\u0131 gereklidir.","stripe_secret":"Stripe gizli alan\u0131 gereklidir.","subject_required":"Konu alan\u0131 zorunludur.","subscriptions":"Abonelikler","successful":"Ba\u015far\u0131l\u0131","sun":"PAZ","term_condition":"Kullan\u0131m \u015eartlar\u0131","testimonial":"Referans","the_term_conditions":"Kullan\u0131m \u015eartlar\u0131 zorunludur.","this_is_analytics_chart":"Bu sizin VCard analiz Tablonuzdur.","this_month":"Bu Ay","this_week":"Bu Hafta","thu":"PER","to":"Kime","today":"Bug\u00fcn","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","tue":"SAL","unavailable":"Kullan\u0131lam\u0131yor","upload_required":"Dosya y\u00fckleme alan\u0131 gereklidir.","user":"Kullan\u0131c\u0131","vcard":"VCard","vcard_iframe":"VCard iframe","vcard_name":"VCard Ad\u0131","vcard_name_required":"Kart ad\u0131 alan\u0131 gereklidir","vcard_service":"VCard Hizmeti","vcard_testimonial":"VCard G\u00f6r\u00fc\u015f\u00fc","website_field_required":"Web sitesi alan\u0131 gereklidir","wed":"\u00c7AR","yes":"Evet","yesterday":"D\u00fcn"},"vi.js":{"Yes_Change":"C\u00f3, Ph\u00ea duy\u1ec7t","add_on":"Th\u00eam v\u00e0o","address_field":"Tr\u01b0\u1eddng \u0111\u1ecba ch\u1ec9 l\u00e0 b\u1eaft bu\u1ed9c.","admin":"Qu\u1ea3n tr\u1ecb vi\u00ean","affiliation_amount_error":"S\u1ed1 ti\u1ec1n li\u00ean k\u1ebft kh\u00f4ng th\u1ec3 v\u01b0\u1ee3t qu\u00e1 100%","agree_term":"B\u1ea1n ph\u1ea3i \u0111\u1ed3ng \u00fd v\u1edbi \u0110i\u1ec1u kho\u1ea3n v\u00e0 \u0111i\u1ec1u ki\u1ec7n.","allowed_file_types":"C\u00e1c lo\u1ea1i t\u1ec7p \u0111\u01b0\u1ee3c ph\u00e9p: png, jpg, jpeg.","allowed_image":"C\u00e1c lo\u1ea1i t\u1ec7p \u0111\u01b0\u1ee3c ph\u00e9p: png, jpg, jpeg.","amount":"S\u1ed1 ti\u1ec1n","app_name_required":"Tr\u01b0\u1eddng t\u00ean \u1ee9ng d\u1ee5ng l\u00e0 b\u1eaft bu\u1ed9c","apply":"\u00c1p d\u1ee5ng","appointment":"Cu\u1ed9c h\u1eb9n","appointments":"Cu\u1ed9c h\u1eb9n","approved":"\u0110\u01b0\u1ee3c ph\u00ea duy\u1ec7t","apr":"Th4","are_you_completed":"B\u1ea1n c\u00f3 ch\u1eafc ch\u1eafn mu\u1ed1n ph\u00ea duy\u1ec7t \u0111i\u1ec1u n\u00e0y kh\u00f4ng?","are_you_sure":"B\u1ea1n c\u00f3 ch\u1eafc ch\u1eafn mu\u1ed1n x\u00f3a \u0111i\u1ec1u n\u00e0y?","are_you_sure_dublicate_vcard":"B\u1ea1n c\u00f3 ch\u1eafc ch\u1eafn mu\u1ed1n t\u1ea1o b\u1ea3n sao VCard n\u00e0y kh\u00f4ng?","aug":"Th8","back_image_field_required":"Tr\u01b0\u1eddng h\u00ecnh \u1ea3nh m\u1eb7t sau l\u00e0 b\u1eaft bu\u1ed9c","blog":"Blog","blog_description":"M\u00f4 t\u1ea3","blog_image_required":"Tr\u01b0\u1eddng h\u00ecnh \u1ea3nh Blog l\u00e0 b\u1eaft bu\u1ed9c.","cancel":"H\u1ee7y","check_email":"Email \u0111\u00e3 t\u1ed3n t\u1ea1i.","choose_one_template":"Ch\u1ecdn m\u1ed9t m\u1eabu","choose_plan":"Ch\u1ecdn k\u1ebf ho\u1ea1ch","city":"Th\u00e0nh ph\u1ed1","click_open_sidebar":"Nh\u1ea5p v\u00e0o Ti\u1ebfp theo \u0111\u1ec3 m\u1edf Sidebar.","click_to_add_vcard_name":"Nh\u1ea5p v\u00e0o \u0111\u00e2y \u0111\u1ec3 th\u00eam t\u00ean Vcard c\u1ee7a b\u1ea1n.","click_to_create_vcards":"Nh\u1ea5p v\u00e0o Ti\u1ebfp theo \u0111\u1ec3 t\u1ea1o VCard c\u1ee7a b\u1ea1n.","click_to_generate_alias":"Nh\u1ea5p v\u00e0o \u0111\u00e2y \u0111\u1ec3 t\u1ea1o Alias URL c\u1ee7a b\u1ea1n.","click_to_go_dashboard":"Nh\u1ea5p v\u00e0o Ti\u1ebfp theo \u0111\u1ec3 ti\u1ebfp t\u1ee5c \u0111\u1ebfn B\u1ea3ng \u0111i\u1ec1u khi\u1ec3n.","click_to_make_vcards":"Nh\u1ea5p v\u00e0o Ti\u1ebfp theo \u0111\u1ec3 t\u1ea1o VCards m\u1edbi.","click_to_open_edit_sidebar":"Nh\u1ea5p v\u00e0o Ti\u1ebfp theo \u0111\u1ec3 truy c\u1eadp Sidebar ch\u1ec9nh s\u1eeda VCard.","click_to_preview":"Nh\u1ea5p v\u00e0o \u0111\u00e2y \u0111\u1ec3 xem tr\u01b0\u1edbc VCard c\u1ee7a b\u1ea1n.","click_to_save_vcard":"Nh\u1ea5p v\u00e0o Ti\u1ebfp theo \u0111\u1ec3 l\u01b0u VCard c\u1ee7a b\u1ea1n.","completed":"Ho\u00e0n th\u00e0nh","copied_successfully":"Li\u00ean k\u1ebft \u0111\u00e3 \u0111\u01b0\u1ee3c sao ch\u00e9p th\u00e0nh c\u00f4ng.","country":"Qu\u1ed1c gia","coupon_code":"M\u00e3 phi\u1ebfu gi\u1ea3m gi\u00e1","coupon_code_apply":"M\u00e3 coupon \u0111\u00e3 \u0111\u01b0\u1ee3c \u00e1p d\u1ee5ng th\u00e0nh c\u00f4ng.","coupon_code_percent_validation":"Gi\u1ea3m gi\u00e1 m\u00e3 coupon kh\u00f4ng \u0111\u01b0\u1ee3c v\u01b0\u1ee3t qu\u00e1 100%.","custom":"T\u00f9y ch\u1ec9nh","custom_link":"Li\u00ean k\u1ebft T\u00f9y ch\u1ec9nh","custom_vcard_number":"S\u1ed1 VCard t\u00f9y ch\u1ec9nh","custom_vcard_price":"Gi\u00e1 VCard t\u00f9y ch\u1ec9nh","dec":"Th12","delete":"X\u00f3a","deleted":"\u0110\u00e3 x\u00f3a","description":"Nh\u1eadp m\u00f4 t\u1ea3 VCard c\u1ee7a b\u1ea1n","description_length":"M\u00f4 t\u1ea3 ph\u1ea3i c\u00f3 \u00edt nh\u1ea5t 3 k\u00fd t\u1ef1.","description_required":"Tr\u01b0\u1eddng m\u00f4 t\u1ea3 l\u00e0 b\u1eaft bu\u1ed9c.","duplicate":"Tr\u00f9ng l\u1eb7p!","duplicate_vcard":"VCard tr\u00f9ng l\u1eb7p!","duplicate_vcard_create":"VCard tr\u00f9ng l\u1eb7p \u0111\u00e3 \u0111\u01b0\u1ee3c t\u1ea1o th\u00e0nh c\u00f4ng","email":"Email","email_required":"Tr\u01b0\u1eddng email l\u00e0 b\u1eaft bu\u1ed9c.","embedtag":"Th\u1ebb nh\u00fang","enquiry":"Y\u00eau c\u1ea7u","enter_valid_email":"Vui l\u00f2ng nh\u1eadp email h\u1ee3p l\u1ec7.","enter_vcard_name":"Vui l\u00f2ng nh\u1eadp t\u00ean Vcard","error":"L\u1ed7i","faqs":"C\u00e2u h\u1ecfi th\u01b0\u1eddng g\u1eb7p","feb":"Th2","first_name_required":"Tr\u01b0\u1eddng t\u00ean l\u00e0 b\u1eaft bu\u1ed9c.","flat":"Gi\u1ea3m gi\u00e1 c\u1ed1 \u0111\u1ecbnh","flutterwave_key":"Tr\u01b0\u1eddng kh\u00f3a Flutterwave l\u00e0 b\u1eaft bu\u1ed9c.","flutterwave_secret":"Tr\u01b0\u1eddng b\u00ed m\u1eadt Flutterwave l\u00e0 b\u1eaft bu\u1ed9c.","fri":"TH\u1ee8 S\u00c1U","from":"T\u1eeb","front_image_field_required":"Tr\u01b0\u1eddng h\u00ecnh \u1ea3nh m\u1eb7t tr\u01b0\u1edbc l\u00e0 b\u1eaft bu\u1ed9c","gallery":"Th\u01b0 vi\u1ec7n","generate_url_alias":"Vui l\u00f2ng t\u1ea1o Alias URL","has_been_completed":"\u0111\u00e3 \u0111\u01b0\u1ee3c ho\u00e0n th\u00e0nh.","has_been_deleted":"\u0111\u00e3 b\u1ecb x\u00f3a.","here_select_vcard_template":"\u1ede \u0111\u00e2y b\u1ea1n c\u00f3 th\u1ec3 ch\u1ecdn m\u1eabu VCard c\u1ee7a m\u00ecnh.","image_too_large":"T\u1ec7p c\u1ee7a b\u1ea1n qu\u00e1 l\u1edbn. K\u00edch th\u01b0\u1edbc t\u1ed1i \u0111a cho ph\u00e9p l\u00e0 1MB.","in_progress":"\u0110ang ti\u1ebfn h\u00e0nh","inquries":"Y\u00eau c\u1ea7u","invalid_country_code":"M\u00e3 qu\u1ed1c gia kh\u00f4ng h\u1ee3p l\u1ec7","invalid_email":"Email kh\u00f4ng h\u1ee3p l\u1ec7","invalid_number":"S\u1ed1 kh\u00f4ng h\u1ee3p l\u1ec7","jan":"Th1","jul":"Th7","jun":"Th6","last_30_days":"30 ng\u00e0y qua","last_7_days":"7 ng\u00e0y qua","last_name_required":"Tr\u01b0\u1eddng h\u1ecd l\u00e0 b\u1eaft bu\u1ed9c.","last_week":"Tu\u1ea7n tr\u01b0\u1edbc","loading":"\u0110ang t\u1ea3i...","location_field_required":"Tr\u01b0\u1eddng \u0111\u1ecba ch\u1ec9 l\u00e0 b\u1eaft bu\u1ed9c","logo_field_required":"Tr\u01b0\u1eddng logo E-Card l\u00e0 b\u1eaft bu\u1ed9c","logo_image_error":"K\u00edch th\u01b0\u1edbc h\u00ecnh \u1ea3nh ph\u1ea3i l\u00e0 150x150 pixel ho\u1eb7c nh\u1ecf h\u01a1n.","manual_payment_guide":"H\u01b0\u1edbng d\u1eabn thanh to\u00e1n th\u1ee7 c\u00f4ng","mar":"Th3","may":"Th5","mon":"Th\u1ee9 Hai","month":"Th\u00e1ng","multi_templates":"C\u1ea7n \u00edt nh\u1ea5t m\u1ed9t m\u1eabu","next":"Ti\u1ebfp theo","nfc_card":"Th\u1ebb NFC","no":"Kh\u00f4ng","nov":"Th11","occupation_field_required":"Tr\u01b0\u1eddng ngh\u1ec1 nghi\u1ec7p l\u00e0 b\u1eaft bu\u1ed9c","oct":"Th10","ok":"\u0110\u1ed3ng \u00fd","onesignal_app_id":"Tr\u01b0\u1eddng Onesignal App ID l\u00e0 b\u1eaft bu\u1ed9c.","onesignal_rest_api_key":"Tr\u01b0\u1eddng Onesignal Rest API Key l\u00e0 b\u1eaft bu\u1ed9c.","password_character":"M\u1eadt kh\u1ea9u ph\u1ea3i c\u00f3 \u00edt nh\u1ea5t 8 k\u00fd t\u1ef1.","password_must_match":"M\u1eadt kh\u1ea9u v\u00e0 x\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u ph\u1ea3i kh\u1edbp.","passwords":"Tr\u01b0\u1eddng m\u1eadt kh\u1ea9u l\u00e0 b\u1eaft bu\u1ed9c.","payment_not_complete":"Thanh to\u00e1n ch\u01b0a ho\u00e0n t\u1ea5t","paypal_key":"Tr\u01b0\u1eddng Client ID Paypal l\u00e0 b\u1eaft bu\u1ed9c.","paypal_mode":"Tr\u01b0\u1eddng ch\u1ebf \u0111\u1ed9 Paypal l\u00e0 b\u1eaft bu\u1ed9c.","paypal_secret":"Tr\u01b0\u1eddng b\u00ed m\u1eadt Paypal l\u00e0 b\u1eaft bu\u1ed9c.","paystack_key":"Tr\u01b0\u1eddng kh\u00f3a Paystack l\u00e0 b\u1eaft bu\u1ed9c.","paystack_secret":"Tr\u01b0\u1eddng b\u00ed m\u1eadt Paystack l\u00e0 b\u1eaft bu\u1ed9c.","phone":"S\u1ed1 \u0111i\u1ec7n tho\u1ea1i","phone_number_required":"Tr\u01b0\u1eddng s\u1ed1 \u0111i\u1ec7n tho\u1ea1i l\u00e0 b\u1eaft bu\u1ed9c.","phonepe_env_required":"Tr\u01b0\u1eddng Phonepe Env l\u00e0 b\u1eaft bu\u1ed9c.","phonepe_merchant_id_required":"Tr\u01b0\u1eddng Phonepe Merchant ID l\u00e0 b\u1eaft bu\u1ed9c.","phonepe_merchant_transaction_id_required":"Tr\u01b0\u1eddng Phonepe Merchant Transaction ID l\u00e0 b\u1eaft bu\u1ed9c.","phonepe_merchant_user_id_required":"Tr\u01b0\u1eddng Phonepe Merchant User ID l\u00e0 b\u1eaft bu\u1ed9c.","phonepe_salt_index_required":"Tr\u01b0\u1eddng Phonepe Salt Index l\u00e0 b\u1eaft bu\u1ed9c.","phonepe_salt_key_required":"Tr\u01b0\u1eddng Phonepe Salt Key l\u00e0 b\u1eaft bu\u1ed9c.","plan":"K\u1ebf ho\u1ea1ch","plan_expire_notification":"Tr\u01b0\u1eddng th\u00f4ng b\u00e1o h\u1ebft h\u1ea1n k\u1ebf ho\u1ea1ch l\u00e0 b\u1eaft bu\u1ed9c.","please_select_user":"Vui l\u00f2ng ch\u1ecdn ng\u01b0\u1eddi d\u00f9ng","please_wait":"Vui l\u00f2ng \u0111\u1ee3i...","privacy_policy":"Ch\u00ednh s\u00e1ch b\u1ea3o m\u1eadt","product":"S\u1ea3n ph\u1ea9m","provide_valid_wbsite_url":"Vui l\u00f2ng nh\u1eadp URL h\u1ee3p l\u1ec7","purchase":"Mua","razorpay_key":"Tr\u01b0\u1eddng kh\u00f3a Razorpay l\u00e0 b\u1eaft bu\u1ed9c.","razorpay_secret":"Tr\u01b0\u1eddng b\u00ed m\u1eadt Razorpay l\u00e0 b\u1eaft bu\u1ed9c.","rejected":"B\u1ecb t\u1eeb ch\u1ed1i","remove":"X\u00f3a","sat":"\u0110\u00c3 NG\u1ed2I","select_all":"Ch\u1ecdn t\u1ea5t c\u1ea3","select_email_required":"Tr\u01b0\u1eddng G\u1eedi Mail l\u00e0 b\u1eaft bu\u1ed9c.","select_hour":"Vui l\u00f2ng ch\u1ecdn ng\u00e0y ho\u1eb7c gi\u1edd","select_one_or_more":"Ch\u1ecdn m\u1ed9t ho\u1eb7c nhi\u1ec1u t\u00ednh n\u0103ng l\u00e0 b\u1eaft bu\u1ed9c","select_payment_type":"Ch\u1ecdn Lo\u1ea1i thanh to\u00e1n","select_user":"Ch\u1ecdn Ng\u01b0\u1eddi d\u00f9ng","select_vcard":"Ch\u1ecdn Vcard","send_email_description":"M\u00f4 t\u1ea3","sep":"Th9","short_description":"Nh\u1eadp m\u00f4 t\u1ea3 ng\u1eafn","skip":"B\u1ecf qua","social_links_img_is_required":"H\u00ecnh \u1ea3nh li\u00ean k\u1ebft x\u00e3 h\u1ed9i l\u00e0 b\u1eaft bu\u1ed9c.","social_links_is_required":"Li\u00ean k\u1ebft m\u1ea1ng x\u00e3 h\u1ed9i l\u00e0 b\u1eaft bu\u1ed9c.","state":"Ti\u1ec3u bang","stripe_key":"Tr\u01b0\u1eddng kh\u00f3a Stripe l\u00e0 b\u1eaft bu\u1ed9c.","stripe_secret":"Tr\u01b0\u1eddng b\u00ed m\u1eadt Stripe l\u00e0 b\u1eaft bu\u1ed9c.","subject_required":"Tr\u01b0\u1eddng Ch\u1ee7 \u0111\u1ec1 l\u00e0 b\u1eaft bu\u1ed9c.","subscriptions":"\u0110\u0103ng k\u00fd","successful":"Th\u00e0nh c\u00f4ng","sun":"M\u1eb6T TR\u1edcI","term_condition":"\u0110i\u1ec1u kho\u1ea3n & \u0110i\u1ec1u ki\u1ec7n","testimonial":"L\u1eddi ch\u1ee9ng th\u1ef1c","the_term_conditions":"\u0110i\u1ec1u kho\u1ea3n & \u0110i\u1ec1u ki\u1ec7n l\u00e0 b\u1eaft bu\u1ed9c.","this_is_analytics_chart":"\u0110\u00e2y l\u00e0 Bi\u1ec3u \u0111\u1ed3 ph\u00e2n t\u00edch VCard c\u1ee7a b\u1ea1n.","this_month":"Th\u00e1ng n\u00e0y","this_week":"Tu\u1ea7n n\u00e0y","thu":"THU","to":"\u0110\u1ebfn","today":"H\u00f4m nay","too_long":"Qu\u00e1 d\u00e0i","too_short":"Qu\u00e1 ng\u1eafn","tue":"TH\u1ee8 3","unavailable":"Kh\u00f4ng kh\u1ea3 d\u1ee5ng","upload_required":"Tr\u01b0\u1eddng t\u1ea3i l\u00ean t\u1ec7p l\u00e0 b\u1eaft bu\u1ed9c.","user":"Ng\u01b0\u1eddi d\u00f9ng","vcard":"VCard","vcard_iframe":"VCard iframe","vcard_name":"T\u00ean VCard","vcard_name_required":"Tr\u01b0\u1eddng t\u00ean Vcard l\u00e0 b\u1eaft bu\u1ed9c","vcard_service":"D\u1ecbch v\u1ee5 VCard","vcard_testimonial":"L\u1eddi ch\u1ee9ng th\u1ef1c VCard","website_field_required":"Tr\u01b0\u1eddng website l\u00e0 b\u1eaft bu\u1ed9c","wed":"Th\u1ee9 T\u01b0","yes":"C\u00f3","yesterday":"H\u00f4m qua"},"zh.js":{"Yes_Change":"\u662f\u7684\uff0c\u6279\u51c6","add_on":"\u9644\u52a0","address_field":"\u5730\u5740\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","admin":"\u7ba1\u7406\u5458","affiliation_amount_error":"\u96b6\u5c5e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7100%","agree_term":"\u60a8\u5fc5\u987b\u540c\u610f\u6761\u6b3e\u548c\u6761\u4ef6\u3002","allowed_file_types":"\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1apng\uff0cjpg\uff0cjpeg\u3002","allowed_image":"\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1apng\uff0cjpg\uff0cjpeg\u3002","amount":"\u6570\u91cf","app_name_required":"\u5e94\u7528\u7a0b\u5e8f\u540d\u79f0\u5b57\u6bb5\u662f\u5fc5\u9700\u7684","apply":"\u5e94\u7528","appointment":"\u7ea6\u4f1a","appointments":"\u7ea6\u4f1a","approved":"\u5df2\u6279\u51c6","apr":"\u56db\u6708","are_you_completed":"\u60a8\u786e\u5b9a\u8981\u6279\u51c6\u5417\uff1f","are_you_sure":"\u60a8\u786e\u5b9a\u8981\u5220\u9664\u5417","are_you_sure_dublicate_vcard":"\u60a8\u786e\u5b9a\u8981\u521b\u5efa\u6b64VCard\u7684\u526f\u672c\u5417\uff1f","aug":"\u516b\u6708","blog":"\u535a\u5ba2","blog_description":"\u63cf\u8ff0","blog_image_required":"\u90e8\u843d\u683c\u5716\u50cf\u6b04\u4f4d\u662f\u5fc5\u9700\u7684\u3002","cancel":"\u53d6\u6d88","check_email":"\u96fb\u5b50\u90f5\u4ef6\u5df2\u7d93\u5b58\u5728\u3002","choose_one_template":"\u9009\u62e9\u4efb\u4f55\u4e00\u4e2a\u6a21\u677f","choose_plan":"\u9009\u62e9\u8ba1\u5212","city":"\u57ce\u5e02","click_open_sidebar":"\u5355\u51fb\u201c\u4e0b\u4e00\u6b65\u201d\u6253\u5f00\u4fa7\u8fb9\u680f.","click_to_create_vcards":"\u5355\u51fb\u201c\u4e0b\u4e00\u6b65\u201d\u521b\u5efa\u60a8\u7684\u7535\u5b50\u540d\u7247.","click_to_generate_alias":"\u5355\u51fb\u6b64\u5904\u751f\u6210\u60a8\u7684\u7f51\u5740\u522b\u540d.","click_to_go_dashboard":"\u5355\u51fb\u201c\u4e0b\u4e00\u6b65\u201d\u8fdb\u5165\u4eea\u8868\u677f.","click_to_make_vcards":"\u5355\u51fb\u201c\u4e0b\u4e00\u6b65\u201d\u5236\u4f5c\u65b0\u7684\u7535\u5b50\u540d\u7247.","click_to_open_edit_sidebar":"\u5355\u51fb\u201c\u4e0b\u4e00\u6b65\u201d\u8bbf\u95ee VCard \u7f16\u8f91\u4fa7\u680f.","click_to_preview":"\u5355\u51fb\u6b64\u5904\u9884\u89c8\u60a8\u7684\u7535\u5b50\u540d\u7247","click_to_save_vcard":"\u5355\u51fb\u201c\u4e0b\u4e00\u6b65\u201d\u4fdd\u5b58\u60a8\u7684\u7535\u5b50\u540d\u7247.","completed":"\u5df2\u5b8c\u6210","copied_successfully":"\u94fe\u63a5\u5df2\u6210\u529f\u590d\u5236\u3002","country":"\u56fd\u5bb6","coupon_code":"\u4f18\u60e0\u5238\u4ee3\u7801","coupon_code_apply":"\u4f18\u60e0\u7801\u5df2\u6210\u529f\u5e94\u7528.","coupon_code_percent_validation":"\u4f18\u60e0\u5238\u6298\u6263\u4e0d\u5f97\u8d85\u8fc7100\uff05\u3002","custom":"\u81ea\u5b9a\u4e49","custom_link":"\u81ea\u5b9a\u4e49\u94fe\u63a5","dec":"\u5341\u4e8c\u6708","delete":"\u5220\u9664","deleted":"\u5df2\u5220\u9664","description":"\u8f93\u5165\u60a8\u7684VCard\u63cf\u8ff0","description_length":"\u63cf\u8ff0\u5fc5\u987b\u81f3\u5c11\u5305\u542b3\u4e2a\u5b57\u7b26\u3002","description_required":"\u63cf\u8ff0\u5b57\u6bb5\u662f\u5fc5\u586b\u9879.","duplicate":"\u91cd\u590d\uff01","duplicate_vcard":"\u91cd\u590dVCard\uff01","duplicate_vcard_create":"\u6210\u529f\u521b\u5efa\u91cd\u590dVCard","email":"\u7535\u5b50\u90ae\u4ef6","email_required":"\u7535\u5b50\u90ae\u4ef6\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","embedtag":"\u5d4c\u5165\u6807\u7b7e","enquiry":"\u67e5\u8be2","enter_valid_email":"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u7535\u5b50\u90ae\u4ef6\u3002","enter_vcard_name":"\u8bf7\u8f93\u5165\u7535\u5b50\u540d\u7247\u540d\u79f0","error":"\u9519\u8bef","faqs":"\u5e38\u89c1\u95ee\u9898","feb":"\u4e8c\u6708","first_name_required":"\u540d\u5b57\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","flat":"\u5e73","flutterwave_key":"Flutterwave\u5bc6\u94a5\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","flutterwave_secret":"Flutterwave\u79d8\u5bc6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","fri":"\u661f\u671f\u4e94","from":"\u4ece","gallery":"\u753b\u5eca","generate_url_alias":"\u8bf7\u751f\u6210\u4e00\u4e2a URL \u522b\u540d","has_been_completed":"\u5df2\u5b8c\u6210\u3002","has_been_deleted":"\u5df2\u88ab\u5220\u9664\u3002","here_select_vcard_template":"\u60a8\u53ef\u4ee5\u5728\u6b64\u5904\u9009\u62e9\u60a8\u7684\u7535\u5b50\u540d\u7247\u6a21\u677f.","image_too_large":"\u60a8\u7684\u6587\u4ef6\u592a\u5927\u3002\u5141\u8a31\u7684\u6700\u5927\u5927\u5c0f\u70ba 1MB\u3002","in_progress":"\u8fdb\u884c\u4e2d","inquries":"\u8be2\u95ee","invalid_country_code":"\u65e0\u6548\u7684\u56fd\u5bb6\u4ee3\u7801","invalid_email":"\u7535\u5b50\u90ae\u4ef6\u65e0\u6548","invalid_number":"\u65e0\u6548\u53f7\u7801","jan":"\u4e00\u6708","jul":"\u4e03\u6708","jun":"\u516d\u6708","last_30_days":"\u6700\u8fd130\u5929","last_7_days":"\u6700\u8fd17\u5929","last_name_required":"\u59d3\u6c0f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","last_week":"\u4e0a\u5468","loading":"\u52a0\u8f7d\u4e2d...","manual_payment_guide":"\u624b\u52a8\u652f\u4ed8\u6307\u5357","mar":"\u4e09\u6708","may":"\u4e94\u6708","mon":"\u661f\u671f\u4e00","month":"\u6708","multi_templates":"\u9700\u8981\u591a\u4e2a\u6a21\u677f","next":"\u4e0b\u4e00\u4e2a","nfc_card":"NFC \u5361","no":"\u4e0d","nov":"\u5341\u4e00\u6708","oct":"\u5341\u6708","ok":"\u597d","onesignal_app_id":"OneSignal \u5e94\u7528 ID \u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","onesignal_rest_api_key":"OneSignal REST API \u5bc6\u94a5\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","password_character":"\u5bc6\u7801\u5fc5\u987b\u81f3\u5c11\u4e3a8\u4e2a\u5b57\u7b26\u3002","password_must_match":"\u5bc6\u7801\u548c\u5bc6\u7801\u786e\u8ba4\u5fc5\u987b\u5339\u914d\u3002","passwords":"\u5bc6\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","payment_not_complete":"\u652f\u4ed8\u672a\u5b8c\u6210","paypal_key":"Paypal \u5ba2\u6237 ID \u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","paypal_mode":"Paypal\u6a21\u5f0f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","paypal_secret":"Paypal\u79d8\u5bc6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","paystack_key":"Paystack\u5bc6\u94a5\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","paystack_secret":"Paystack\u79d8\u5bc6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","phone":"\u7535\u8bdd","phone_number_required":"\u7535\u8bdd\u53f7\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","phonepe_env_required":"Phonepe\u73af\u5883\u5b57\u6bb5\u662f\u5fc5\u586b\u7684.","phonepe_merchant_id_required":"Phonepe\u5546\u6237ID\u5b57\u6bb5\u662f\u5fc5\u586b\u7684.","phonepe_merchant_transaction_id_required":"Phonepe\u5546\u6237\u4ea4\u6613ID\u5b57\u6bb5\u662f\u5fc5\u586b\u7684.","phonepe_merchant_user_id_required":"Phonepe\u5546\u6237\u7528\u6237ID\u5b57\u6bb5\u662f\u5fc5\u586b\u7684.","phonepe_salt_index_required":"Phonepe\u76d0\u503c\u7d22\u5f15\u5b57\u6bb5\u662f\u5fc5\u586b\u7684.","phonepe_salt_key_required":"Phonepe\u76d0\u503c\u5bc6\u94a5\u5b57\u6bb5\u662f\u5fc5\u586b\u7684.","plan":"\u8ba1\u5212","plan_expire_notification":"\u8ba1\u5212\u5230\u671f\u901a\u77e5\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","please_select_user":"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7528\u6237","please_wait":"\u8bf7\u7a0d\u7b49...","privacy_policy":"\u9690\u79c1\u653f\u7b56","product":"\u4ea7\u54c1","purchase":"\u8d2d\u4e70","razorpay_key":"Rozorpay \u5173\u952e\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","razorpay_secret":"Rozorpay \u79d8\u5bc6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","rejected":"\u5df2\u62d2\u7edd","remove":"\u79fb\u9664","sat":"\u661f\u671f\u516d","select_all":"\u9009\u62e9\u5168\u90e8","select_email_required":"\u53d1\u9001\u90ae\u4ef6\u5b57\u6bb5\u662f\u5fc5\u586b\u9879.","select_hour":"\u8bf7\u9009\u62e9\u65e5\u671f\u6216\u5c0f\u65f6","select_one_or_more":"\u9009\u62e9\u4e00\u4e2a\u6216\u591a\u4e2a\u529f\u80fd\u662f\u5fc5\u9700\u7684","select_payment_type":"\u9009\u62e9\u4ed8\u6b3e\u65b9\u5f0f","select_user":"\u9009\u62e9\u7528\u6237","select_vcard":"\u9009\u62e9\u7535\u5b50\u540d\u7247","send_email_description":"\u63cf\u8ff0","sep":"\u4e5d\u6708","short_description":"\u8bf7\u8f93\u5165\u7b80\u77ed\u63cf\u8ff0","skip":"\u8df3\u8fc7","social_links_img_is_required":"\u793e\u4ea4\u94fe\u63a5\u56fe\u7247\u662f\u5fc5\u9700\u7684\u3002","social_links_is_required":"\u793e\u4ea4\u94fe\u63a5\u662f\u5fc5\u9700\u7684\u3002","state":"\u5dde\/\u7701","stripe_key":"Stripe\u5bc6\u94a5\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","stripe_secret":"Stripe\u79d8\u5bc6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","subject_required":"\u4e3b\u9898\u5b57\u6bb5\u662f\u5fc5\u586b\u9879.","subscriptions":"\u8ba2\u9605","successful":"\u6210\u529f","sun":"\u661f\u671f\u65e5","term_condition":"\u6761\u6b3e\u548c\u6761\u4ef6","testimonial":"\u63a8\u8350","the_term_conditions":"\u9700\u8981\u63a5\u53d7\u6761\u6b3e\u548c\u6761\u4ef6\u3002","this_is_analytics_chart":"\u8fd9\u662f\u60a8\u7684 VCard \u5206\u6790\u56fe\u8868.","this_month":"\u672c\u6708","this_week":"\u672c\u5468","thu":"\u661f\u671f\u56db","to":"\u5230","today":"\u4eca\u5929","too_long":"\u592a\u957f","too_short":"\u592a\u77ed","tue":"\u661f\u671f\u4e8c","unavailable":"\u4e0d\u53ef\u7528","upload_required":"\u4e0a\u4f20\u6587\u4ef6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","user":"\u7528\u6237","vcard":"\u540d\u7247","vcard_iframe":"V\u5361 iframe","vcard_name":"VCard\u540d\u79f0","vcard_service":"V\u5361\u670d\u52a1","vcard_testimonial":"V\u5361\u63a8\u8350","wed":"\u661f\u671f\u4e09","yes":"\u662f","yesterday":"\u6628\u5929"}});
})();
